/*
  start of a generic gui Device
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <guiDevice.h>



GuiDevice::GuiDevice( QWidget *parent=0, 
 		      const char *name=0 ) : QWidget(parent,name) {

  menuDescription=new MenuDescription(i18n("empty Menu"));
  preferences=new Preferences();
  outputDevice=NULL;
}


GuiDevice::~GuiDevice() {
  delete menuDescription;
}

void GuiDevice::insertMenu(const char* text,QObject* receiver,
			   const char* signal) {
  menuDescription->insertMenu(text,receiver,signal);
}


Preferences* GuiDevice::getPreferences() {
  return preferences;
}


KPopupMenu* GuiDevice::createPopupMenu() {
  return menuDescription->createPopupMenu();
}


void GuiDevice::attachTo(OutputDevice* outputDevice) {
  if (this->outputDevice != NULL) {
    cout << "error:connecting to already connected device!"<<endl;
    exit(1);
  }
  if (outputDevice == NULL) {
    cout << "error attaching NULL device"<<endl;
    exit(0);
  }
  this->outputDevice=outputDevice;
  menuDescription->setTitle(outputDevice->getNodeName());
  preferences->setCaption(outputDevice->getNodeName());
  connect(outputDevice->getEventQueue(),SIGNAL(processEvent(char)),
	  this,SLOT(processEvent(char)));
}


void GuiDevice::detach() {
  if (this->outputDevice != NULL) {
    disconnect(outputDevice->getEventQueue(),NULL,this,NULL);
    outputDevice=NULL;
  } else {
    cout << "attempt to detach from NULL"<<endl;
  }
}



void GuiDevice::processEvent(char eventId) {
}


 

