/*
  This jumps in the stream. 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#include <guiJumpDevice.h>




GuiJumpDevice::GuiJumpDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  updateSlider=false;
  sliderWidth=250;
  audioStreamInfoDevice=NULL;
  lProcessEvents=true;
  sb=NULL;
  jumps=0;
}


GuiJumpDevice::~GuiJumpDevice() {
}



void GuiJumpDevice::attachTo(AudioStreamInfoDevice* audioStreamInfoDevice) {
  this->audioStreamInfoDevice=audioStreamInfoDevice;
  GuiDevice::attachTo(audioStreamInfoDevice);
  processEvent(_AUDIOSTREAMINFO_STATUS_CHANGE);
  processEvent(_AUDIOSTREAMINFO_MUSIC_CHANGE);
  processEvent(_AUDIOSTREAMINFO_TIME_CHANGE);
}


void GuiJumpDevice::detach() {
  audioStreamInfoDevice=NULL;
  GuiDevice::detach();
}


void GuiJumpDevice::processEvent(char eventId) {
  if (lProcessEvents == false) {
    return;
  }
  if (sb == NULL) {
    cout << "sb == NULL"<<endl;
    return;
  }
  switch (eventId) {
  case _AUDIOSTREAMINFO_TIME_CHANGE : {
    TimeInfo* timeInfo=audioStreamInfoDevice->getTimeInfo();
    float totalSec=timeInfo->getTotalSec();
    if (updateSlider) {
      int val=0;
      // the problem with some sound formats is, that
      // they don't know the total length of the song.
      // thus a jump to a second is not possible.
      // The mod file format has only a number of "jump" points
      // where we can jump to.
      // We only do the logical mapping time to jump
      // if the jumppoints and the length is the same.

      if (len == jumps) {
	if (len != 0) {
	  val=(int)(((float)100*totalSec)/(float)len);
	}
      }
      if (val != sb->value()) {
	sb->setValue(val);
      }
    }
    break;
  }    
  case _AUDIOSTREAMINFO_STATUS_CHANGE : {
    StatusInfo* statusInfo=audioStreamInfoDevice->getStatusInfo();
    status=statusInfo->getStatus();
    break;
  }
  case _AUDIOSTREAMINFO_MUSIC_CHANGE : {
    MusicInfo* musicInfo=audioStreamInfoDevice->getMusicInfo();
    len=musicInfo->getLen();
    jumps=musicInfo->getJumps();

    //compatiblility switch for old command line player
    // HACK ALERT! !

    if (jumps==0){
      jumps=len;
    }
    break;
  }
  }

  updateSlider=false;
  if ((status == _STATUS_PLAYING) && (len > 0)) {
    updateSlider=true;
  }
  if (status == _STATUS_STOPPED) {
    sb->setValue(0);
  }
  if (len <= 0) {
    sb->setValue(0);
  }
    

}
    


void GuiJumpDevice::buildGui() {
  sb = new QSlider(QSlider::Horizontal, this);
  sb->setRange(0,100);
  sb->setValue( 0 );
  sb->setMinimumSize( sizeHint() );
  sb->setMaximumSize( sizeHint() );
  connect(sb,SIGNAL(sliderPressed()),SLOT(sliderPressed()));
  connect(sb,SIGNAL(sliderReleased()),SLOT(sliderReleased()));
}


void GuiJumpDevice::sliderPressed() {
  if (updateSlider) {
    lProcessEvents=false;
  }
}


void GuiJumpDevice::sliderReleased() {
  int val=sb->value();
  int point=(int)(((float)val*(float)jumps)/(float)100);
  emit(jump(point));

  lProcessEvents=true;
  updateSlider=false;
}


QSize GuiJumpDevice::sizeHint() const {
  return QSize(sliderWidth,15);
}

 



