/*
  gui part for the status device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiStatusDevice.h>




GuiStatusDevice::GuiStatusDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  eventMask=_AUDIOSTREAMINFO_STATUS_CHANGE;
  audioStreamInfoDevice=NULL;
}


GuiStatusDevice::~GuiStatusDevice() {
}



void GuiStatusDevice::attachTo(AudioStreamInfoDevice* audioStreamInfoDevice) {
  this->audioStreamInfoDevice=audioStreamInfoDevice;
  GuiDevice::attachTo(audioStreamInfoDevice);
  processEvent(_AUDIOSTREAMINFO_STATUS_CHANGE);
}


void GuiStatusDevice::detach() {
  GuiDevice::detach();
  audioStreamInfoDevice=NULL;
}




void GuiStatusDevice::processEvent(char eventId) {
  if (eventId != _AUDIOSTREAMINFO_STATUS_CHANGE) {
    return;
  }
  repaint(false);
}


int GuiStatusDevice::getStatus() {
  if (audioStreamInfoDevice != NULL) {
    StatusInfo* statusInfo=audioStreamInfoDevice->getStatusInfo();
    return statusInfo->getStatus();
  }
  return 0;
}


QSize GuiStatusDevice::sizeHint() const {
  return QSize(40,40);
}


void GuiStatusDevice::paintEvent ( QPaintEvent * paintEvent ) {
  int status;
  QPainter paint;

  erase(0,0,width(),height());
  status=getStatus();
  if (status == _STATUS_PLAYING) {
    paint.begin( this );
    paint.drawText(0,30,i18n("Playing"));
    paint.end();  
  }
  if (status == _STATUS_STOPPED) {
    paint.begin( this );
    paint.drawText(0,30,i18n("Stopped"));
    paint.end();  
  }
  if (status == _STATUS_PAUSED) {
    paint.begin( this );
    paint.drawText(0,30,i18n("Paused"));
    paint.end();  
  }
}
