/*
  show if stream is stero or not
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <guiStereoDevice.h>




GuiStereoDevice::GuiStereoDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  audioStreamInfoDevice=NULL;
}


GuiStereoDevice::~GuiStereoDevice() {
}



void GuiStereoDevice::attachTo(AudioStreamInfoDevice* audioStreamInfoDevice) {
  this->audioStreamInfoDevice=audioStreamInfoDevice;
  GuiDevice::attachTo(audioStreamInfoDevice);
  processEvent(_AUDIOSTREAMINFO_AUDIO_CHANGE);
}


void GuiStereoDevice::detach() {
  audioStreamInfoDevice=NULL;
  GuiDevice::detach();
}




void GuiStereoDevice::processEvent(char eventId) {
  if (eventId != _AUDIOSTREAMINFO_AUDIO_CHANGE) {
    return;
  }
  repaint(false);
}





int GuiStereoDevice::getStereo() {
  if (audioStreamInfoDevice != NULL) {
    AudioInfo* audioInfo=audioStreamInfoDevice->getAudioInfo();
    return audioInfo->getStereo();
  }
  return 0;
}


QSize GuiStereoDevice::sizeHint() const {
  return QSize(20,10);
}


void GuiStereoDevice::paintEvent ( QPaintEvent * paintEvent ) {
  int stereo;
  QPainter paint;

  erase(0,0,width(),height());
  stereo=getStereo();
  if (stereo == true) {
    paint.begin( this );
    paint.drawText(0,10,i18n("stereo"));
    paint.end();  
  } else {
    paint.begin( this );
    paint.drawText(0,10,i18n("mono"));
    paint.end();  
  }
}
