/*
  simple control gui for a TimerDevice
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __GUITIMERDEVICE_H
#define __GUITIMERDEVICE_H

#include <qpainter.h>
#include <qpushbt.h>
#include <qtimer.h> 


#include <devices/audioStreamInfoDevice.h>
#include <yafcore/buffer.h>

#include <guiDevice.h>
#include <timerDeviceConfig.h>




class GuiTimerDevice : public GuiDevice {
  Q_OBJECT

  AudioStreamInfoDevice* audioStreamInfoDevice;
  TimerDeviceConfig* timerDeviceConfig;

 public:
  GuiTimerDevice( QWidget *parent=0, const char *name=0 );
  ~GuiTimerDevice();
  void attachTo(AudioStreamInfoDevice* audioStreamInfoDevice);
  void detach();


  char* getTimeString();
  QSize sizeHint() const;
  void paintEvent ( QPaintEvent * paintEvent );

 public slots:
  void configure();
  void mousePressEvent ( QMouseEvent* mouseEvent);
  void timeout();

 private:
  Buffer* timeString;
};


#endif
