/*
  Configuration for the InfoWidget
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __INFODEVICECONFIG_H
#define __INFODEVICECONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>

#include <tag.h>
#include <song.h>

/**
   A small part of the dialog is taken from kmp3 another KDE mp3 player.
   Kmp3 was written by:
   <pre>
   <Cajus Pollmeier> i00160@urmel.mfh-iserlohn.de
   <Antoine Laydier> smf@mail.dotcom.fr
   </pre>

*/


class InfoDeviceConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  QString lineID3_cfg;
  QString lineFile_cfg;
  int useID3_cfg;

 public:
   InfoDeviceConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~InfoDeviceConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
   void translate(Song* song,Buffer* dest);

 signals:
   void applyEvent();

 public slots:
   void setUseID3(bool val);

 private:
   int parseID3(Song*song,
		char* macro, Buffer* dest,int lError=true);

   int parseFilename(Song* song,
		     char* macro, Buffer* dest,int lError=true);
   

   QCheckBox* useID3Box;

   QGroupBox* infoID3Box;
   QLabel* lineID3Lable;
   QLineEdit* lineID3Edit;
   QLabel* legendID3;

   QGroupBox* infoFileBox;
   QLabel* lineFileLable;
   QLineEdit* lineFileEdit;
   QLabel* legendFile;

   Buffer* tmp1;
   Buffer* tmp2;
};
#endif
