/*
  Configuration for the SpectrumAnalyser
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <spectrumAnalyserDeviceConfig.h>


SpectrumAnalyserDeviceConfig::SpectrumAnalyserDeviceConfig(
        const char* configGroup,QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();


  useSpaBox = new QCheckBox(i18n("Spectrum Analyser"), this, "useSpaBox");
  useSpaBox->setGeometry(20,10,125,25);
  useSpaBox->setChecked(useSpa_cfg);
  connect(useSpaBox,SIGNAL(toggled(bool)),this,SLOT(setUseSpa(bool)));
  
  QButtonGroup *bg = new QButtonGroup(i18n("Analyser Mode"), this );
  QVBoxLayout *vbox = new QVBoxLayout(bg, 5);
  vbox->addSpacing( bg->fontMetrics().height() );
  QRadioButton* rb1 = new QRadioButton(i18n("plain fft (fast)") ,bg );
  bg->insert(rb1,__ANALYSE_MODE_SHORT);
  rb1->setMinimumSize( rb1->sizeHint() );

  QRadioButton* rb2 = new 
    QRadioButton(i18n("variable scaling (fix-ftt,very slow,nicer)"),bg);
  rb2->setMinimumSize( rb2->sizeHint() );
  bg->insert(rb2,__ANALYSE_MODE_FLOAT);
 

  vbox->addWidget(rb1);
  vbox->addWidget(rb2);


  bg->setButton(analyseMode_cfg);
  bg->setGeometry(20, 40, 300, 120 );

  connect(bg,SIGNAL(pressed (int)),SLOT(setAnalyseMode(int)));

}


SpectrumAnalyserDeviceConfig::~SpectrumAnalyserDeviceConfig() {
}


void SpectrumAnalyserDeviceConfig::setUseSpa(bool val) {
  useSpa_cfg=val;
}
   

int SpectrumAnalyserDeviceConfig::getUseSpa() {
  return useSpa_cfg;
}


void SpectrumAnalyserDeviceConfig::setAnalyseMode(int val) {
  analyseMode_cfg=val;
}
   

int SpectrumAnalyserDeviceConfig::getAnalyseMode() {
  return analyseMode_cfg;
}


const char* SpectrumAnalyserDeviceConfig::getGroupName() {
  return i18n("Analyser");
}


void SpectrumAnalyserDeviceConfig::load() {
  config->setGroup(configGroup);
  useSpa_cfg=config->readBoolEntry( "useSpa", true);
  analyseMode_cfg=config->readNumEntry( "AnalyseMode",__ANALYSE_MODE_SHORT);
}


void SpectrumAnalyserDeviceConfig::save() {
  useSpa_cfg=useSpaBox->isChecked();
  config->setGroup(configGroup);
  config->writeEntry("useSpa",useSpa_cfg);
  config->writeEntry("AnalyseMode",analyseMode_cfg);
}


void SpectrumAnalyserDeviceConfig::apply() {
  save();
  emit(applyEvent());
}



 

