/*
  a nicer widget for the decoder control
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <controlWidget.h>





ControlWidget::ControlWidget( QWidget *parent=0, 
			      const char *name=0 ): QWidget (parent,name) {
  
}


ControlWidget::~ControlWidget() {
}



QSize ControlWidget::sizeHint() const {
  QSize size(150,20);
  return size;
}


void ControlWidget::buildGui() {
  KIconLoader *loader = kapp->getIconLoader();
  layout = new QBoxLayout( this, QBoxLayout::LeftToRight, 1 );

  ADD_BUTTON(prevButton,layout,SIGNAL(playPrevEvent()),"kmpg_prev.xpm" );
  ADD_BUTTON(playButton,layout,SIGNAL(playCurrentEvent()),"kmpg_play_off.xpm");
  ADD_BUTTON(pauseButton,layout,SIGNAL(playPauseEvent()),"kmpg_pause_off.xpm");
  ADD_BUTTON(stopButton,layout, SIGNAL(playStopEvent()),"kmpg_stop_off.xpm" );
  ADD_BUTTON(prevButton,layout, SIGNAL(playNextEvent()),"kmpg_next.xpm" );
  layout->addSpacing(10);
  ADD_BUTTON(ejectButton,layout, SIGNAL(ejectEvent()),"kmpg_eject.xpm" );
  

}


