/*
  nice frequency display for KDE-skin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include<freqWidget.h>


#define FONT     "helvetica"
#define FONTSIZE 10
#define BGCOLOR 0,0,0
#define COLOR3  0,255,0


FreqWidget::FreqWidget( QWidget *parent=0, const char *name=0 ) :
  GuiFreqDevice(parent,name){
  text=new char[10];
}


FreqWidget::~FreqWidget() {
  delete text;
}


QSize FreqWidget::sizeHint() const {
  return QSize(30,10);
}


void FreqWidget::paintEvent ( QPaintEvent * paintEvent ) {
  int w=width();
  int h=height();

  int freq=getFreq()/1000;
  snprintf(text,10,"%dKHz",freq);

  QFont font( FONT, FONTSIZE );
  QFontMetrics fontMetrics( font );
  QPainter paint;
  paint.begin( this );
  paint.setBackgroundColor(QColor(BGCOLOR));
  paint.eraseRect(0,0,w,h);
  paint.setFont(font);
  paint.setPen( QColor(COLOR3) );
  paint.drawText(0,10,text);
  paint.end();  
}

