/*
  kdeSkin (Skin, not really, but pluggable)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <kmpgSkin.h>


KmpgSkin::KmpgSkin(QWidget *parent=0, const char *name=0)
  :GuiPlugin(parent,name) {
  preferences=new Preferences();
  kmpgSkinConfig=new KmpgSkinConfig("kmpgSkin",preferences);
  preferences->addTab(kmpgSkinConfig,kmpgSkinConfig->getGroupName());
  setBackgroundColor(QColor(black));

  QBoxLayout* topLayout = new QVBoxLayout( this, 1 );
  topLayout->addSpacing(0);

  QBoxLayout* b = new QHBoxLayout();
  topLayout->addLayout(b);
  guiSpectrumAnalyser = new GuiSpectrumAnalyser(this);
  b->addWidget(guiSpectrumAnalyser);


  QBoxLayout* b7 = new QVBoxLayout();
  b->addLayout(b7);

     QBoxLayout* b8 = new QHBoxLayout();
      
     b7->addLayout(b8);
     b8->addSpacing(0);
     b8->addStretch(0);
 
     statusWidget = new StatusWidget(this);
     b8->addWidget(statusWidget);
     timerWidget = new TimerWidget(this);
     b8->addWidget(timerWidget);
     b8->addSpacing(0);
     b8->addStretch(0);
     b8->addWidget(new QWidget());
 
 
  QBoxLayout* b3 = new QHBoxLayout();
  topLayout->addLayout(b3);

  stereoWidget = new StereoWidget(this);
  b3->addWidget(stereoWidget);
  freqWidget = new FreqWidget(this);
  b3->addWidget(freqWidget);
  bpsWidget = new BPSWidget(this);
  b3->addWidget(bpsWidget); 

  volumeWidget = new VolumeWidget(this);
  volumeWidget->buildGui();
  b3->addWidget(volumeWidget);
  guiBalanceDevice = new GuiBalanceDevice(this);
  guiBalanceDevice->buildGui();
  b3->addWidget(guiBalanceDevice);

  QBoxLayout* b1 = new QVBoxLayout();
  topLayout->addLayout(b1);

  infoWidget = new InfoWidget(this);
  b1->addWidget(infoWidget);


  guiJumpDevice = new GuiJumpDevice(this);
  guiJumpDevice->buildGui();
  b1->addWidget(guiJumpDevice);
  connect(guiJumpDevice,SIGNAL(jump(int)),this,SIGNAL(jump(int)));

  QBoxLayout* b2 = new QHBoxLayout();
  topLayout->addLayout(b2);

  controlWidget = new ControlWidget(this); 
  controlWidget->buildGui();
  b2->addWidget(controlWidget);
  connect(controlWidget,SIGNAL(playCurrentEvent()),
	  this,SIGNAL(playCurrentEvent()));
  connect(controlWidget,SIGNAL(playNextEvent()),
	  this,SIGNAL(playNextEvent()));
  connect(controlWidget,SIGNAL(playPrevEvent())
	  ,this,SIGNAL(playPrevEvent()));
  connect(controlWidget,SIGNAL(playStopEvent()),
	  this,SIGNAL(playStopEvent()));
  connect(controlWidget,SIGNAL(playPauseEvent()),
	  this,SIGNAL(playPauseEvent()));
  
  guiBufferInfoDevice = new GuiBufferInfoDevice(this);
  b2->addWidget(guiBufferInfoDevice);

  QBoxLayout* b9 = new QVBoxLayout();
  b2->addLayout(b9);
  guiShuffle = new GuiShuffle(i18n("Rnd:"),this);
  guiShuffle->setChecked(false);
  connect(guiShuffle,SIGNAL(setShuffleEvent(int)),
	  this,SIGNAL(shuffleClickedEvent(int)));
  b9->addWidget(guiShuffle);
  
  guiRepeat = new GuiRepeat(i18n("Cnt:"),this);
  b9->addWidget(guiRepeat);
  guiRepeat->setChecked(false);
  connect(guiRepeat,SIGNAL(setRepeatEvent(int)),
	  this,SIGNAL(repeatClickedEvent(int)));

  setSize();
}


KmpgSkin::~KmpgSkin() {
  delete preferences;
}


void KmpgSkin::setSong(Song* song) {
  infoWidget->setSong(song);
  bpsWidget->setSong(song);
}


void KmpgSkin::attachTo(StandardGraph* standardGraph) {
  SpectrumAnalyserDevice* spectrumAnalyserDevice
                          =standardGraph->getSpectrumAnalyserDevice();

  VolumeDevice* volumeDevice=standardGraph->getVolumeDevice();

  AudioStreamInfoDevice* audioStreamGeneralInfoDevice=
                    standardGraph->getGeneralInfoDevice();

  AudioStreamInfoDevice* audioStreamBufferInfoDevice=
                    standardGraph->getBufferInfoDevice();
  AudioStreamInfoDevice* audioStreamJumpInfoDevice=
                    standardGraph->getJumpInfoDevice();
  guiSpectrumAnalyser->attachTo(spectrumAnalyserDevice);
  statusWidget->attachTo(audioStreamGeneralInfoDevice);
  timerWidget->attachTo(audioStreamJumpInfoDevice); 
  volumeWidget->attachTo(volumeDevice);
  guiBalanceDevice->attachTo(volumeDevice);
  guiBufferInfoDevice->attachTo(audioStreamBufferInfoDevice);
  stereoWidget->attachTo(audioStreamGeneralInfoDevice);
  freqWidget->attachTo(audioStreamGeneralInfoDevice);
  bpsWidget->attachTo(audioStreamGeneralInfoDevice);
  infoWidget->attachTo(audioStreamGeneralInfoDevice);
  guiJumpDevice->attachTo(audioStreamJumpInfoDevice);
}


void KmpgSkin::detach() {
  guiSpectrumAnalyser->detach();
  statusWidget->detach();
  timerWidget->detach();
  volumeWidget->detach();
  guiBalanceDevice->detach();
  guiBufferInfoDevice->detach();
  stereoWidget->detach();
  freqWidget->detach();
  bpsWidget->detach();
}


QSize KmpgSkin::sizeHint () const {
  return QSize(250,105);
}


void KmpgSkin::configure() {
  preferences->show();
}


int  KmpgSkin::getSkinId() {
  return __SKINID_KMPG;
}


/**
   I hate QT. Why do they not have a preferred size , like in java?
*/
void KmpgSkin::setSize() {
  guiSpectrumAnalyser->setMinimumSize(guiSpectrumAnalyser->sizeHint());
  statusWidget->setMinimumSize(statusWidget->sizeHint());
  timerWidget->setMinimumSize(timerWidget->sizeHint());
  volumeWidget->setMinimumSize(volumeWidget->sizeHint());
  guiBalanceDevice->setMinimumSize(guiBalanceDevice->sizeHint());
  guiBufferInfoDevice->setMinimumSize(guiBufferInfoDevice->sizeHint());
  stereoWidget->setMinimumSize(stereoWidget->sizeHint());
  freqWidget->setMinimumSize(freqWidget->sizeHint());
  bpsWidget->setMinimumSize(bpsWidget->sizeHint());
  infoWidget->setMinimumSize(infoWidget->sizeHint());
  guiJumpDevice->setMinimumSize(guiJumpDevice->sizeHint());
}


void KmpgSkin::setRepeat(int val) {
  guiRepeat->setChecked(val);
}


void KmpgSkin::setShuffle(int val) {
  guiShuffle->setChecked(val);
}


void KmpgSkin::setPlaylist(int val) {
}

  



