/*
  a class for led digits
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "led.h"
#include "led_pixmaps.h"
#include "info_pixmaps.h"


LED::LED() {

  pixmapArray[_LED_DIGIT_0]=new QPixmap(digit_0);
  pixmapArray[_LED_DIGIT_1]=new QPixmap(digit_1);
  pixmapArray[_LED_DIGIT_2]=new QPixmap(digit_2);
  pixmapArray[_LED_DIGIT_3]=new QPixmap(digit_3);
  pixmapArray[_LED_DIGIT_4]=new QPixmap(digit_4);
  pixmapArray[_LED_DIGIT_5]=new QPixmap(digit_5);
  pixmapArray[_LED_DIGIT_6]=new QPixmap(digit_6);
  pixmapArray[_LED_DIGIT_7]=new QPixmap(digit_7);
  pixmapArray[_LED_DIGIT_8]=new QPixmap(digit_8);
  pixmapArray[_LED_DIGIT_9]=new QPixmap(digit_9);

  pixmapArray[_LED_PANEL]=new QPixmap(panel);
  pixmapArray[_LED_DOTS]=new QPixmap(points);
  pixmapArray[_LED_BLANK]=new QPixmap(digit_blank);
  pixmapArray[_LED_PAUSE]=new QPixmap(digit_pause);
  pixmapArray[_LED_PLAY]=new QPixmap(digit_play);
  pixmapArray[_LED_MINUS]=new QPixmap(digit_minus);
  pixmapArray[_LED_STOP]=new QPixmap(digit_stop);

  pixmapArray[_LED_COL_RIGHT]=new QPixmap(col_right);
  pixmapArray[_LED_A]=new QPixmap(bst_A);
  pixmapArray[_LED_B]=new QPixmap(bst_B);
  pixmapArray[_LED_C]=new QPixmap(bst_C);
  pixmapArray[_LED_D]=new QPixmap(bst_D);
  pixmapArray[_LED_E]=new QPixmap(bst_E);
  pixmapArray[_LED_F]=new QPixmap(bst_F);

  pixmapArray[_LED_COPYRIGHT_TRUE]=new QPixmap(copyright_xpm);
  pixmapArray[_LED_COPYRIGHT_FALSE]=new QPixmap(nocopyright_xpm);
  pixmapArray[_LED_STEREO]=new QPixmap(stereo_xpm);
  pixmapArray[_LED_MONO]=new QPixmap(mono_xpm);
  
 

}


LED::~LED() {
  int i;

  for(i=0;i<_MAX_LED_ELEMENT;i++) {
    delete pixmapArray[i];
  }
}


QPixmap* LED::getPixmap(int type) {
  if ((type < 0) || (type > _MAX_LED_ELEMENT)) {
    cout << "illegal access :"<<type<<" to led pixmaps.Choosing default"<<endl;
    type=0;
  }
  return pixmapArray[type];
}

