/*
  a nicer widget for the volume.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "volumeWidget.h"




VolumeWidget::VolumeWidget( QWidget *parent=0, const char *name=0 ):
             GuiVolumeDevice( parent, name ) {
  setBackgroundColor(QColor(0,0,0));
}


VolumeWidget::~VolumeWidget() {
}


void VolumeWidget::buildGui() {
  slider = new KSlider(0,100,5,100,KSlider::Horizontal,this,"Slider");

  slider->setTickmarks( QSlider::NoMarks );
  slider->setValue(getVolume());
  slider->setGeometry(0,0,80,15);
  slider->setBackgroundColor(QColor(0,0,0));
  connect(this,SIGNAL(valueChanged(int)),slider,SLOT(setValue(int)));
  connect(slider,SIGNAL(valueChanged(int)),this,SIGNAL(valueChanged(int)));
}


QSize VolumeWidget::sizeHint() const {
  QSize size(80,15);
  return size;
}



 
