/*
  standard Button for winamp Skin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <waBPS.h>


WaBPS::WaBPS(WaSkinModell* waSkinModell,QWidget* parent=0,char* name=0):
GuiBPSDevice(parent,name){
  this->waSkinModell=waSkinModell;
  connect(waSkinModell,SIGNAL(event_WA_SKIN_TEXT()),
	  this,SLOT(pixmapChange()));
  completePixmap=new QPixmap();
  buildPixmap=new QPixmap();

  QSize size=sizeHint();
  completePixmap->resize(size.width(),size.height());
  text=new Buffer(10);
  WaSkinDesc* waSkinDesc=waSkinModell->getWaSkinMapDesc(_WA_MAPPING_BPS);
  setGeometry((*waSkinDesc->getGeometry()));
  connect(this,SIGNAL(setSongEvent()),this,SLOT(pixmapChange()));
  pixmapChange();
}

WaBPS::~WaBPS() {
  delete completePixmap;
  delete buildPixmap;
  delete text;
}



void WaBPS::setSongEvent() {
  pixmapChange();
}


QSize WaBPS::sizeHint() const {
  WaSkinDesc* waSkinDesc=waSkinModell->getWaSkinMapDesc(_WA_MAPPING_BPS);
  return QSize(waSkinDesc->getWidgetWidth(),waSkinDesc->getWidgetHeight());
}


void WaBPS::paintEvent ( QPaintEvent * paintEvent ) {


  QPainter paint;
  paint.begin( this );
  paint.drawPixmap(0,0,*completePixmap);
  paint.end();  



}




void WaBPS::pixmapChange() {
  int i;
  
  int bps=getBPS();
  text->clear();
  snprintf(text->getData(),4,"%3d",bps);
  int x=0;

  for(i=0;i<text->len();i++) {
    waSkinModell->getNumber(_WA_SKIN_TEXT,text->getData()[i],buildPixmap);
    bitBlt(completePixmap,x,0,buildPixmap);
    x=x+buildPixmap->width();
  }


  repaint(false);
}
     
