/*
  configuration for kmpgSkin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <waSkinConfig.h>




WaSkinConfig::WaSkinConfig(const char* configGroup,
			     QWidget * parent=0, const char * name=0 ) 
  : PrefConfig(parent,name) {

  urlList=new QStrList();
  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();

  QLabel* lineLabel1=new QLabel(this);
  lineLabel1->setGeometry(20,20,300,20);
  lineLabel1->setText(i18n("Enter a directory for skins:"));

  lineEdit= new QComboBox (true, this );
  lineEdit->setGeometry(20, 40, 300, 25 );
  lineEdit->setSizeLimit(10);
  lineEdit->insertStrList(urlList);
  connect(lineEdit,SIGNAL(highlighted(int)),this,SLOT(showAt(int)));

  QLabel* lineLable1 = new QLabel(this);
  lineLable1->setGeometry(20,80,300,20);
  lineLable1->setText(i18n("Note:"));

  QLabel* lineLable2 = new QLabel(this);
  lineLable2->setGeometry(20,110,300,20);
  lineLable2->setText(i18n("You can drop directories or compressed files"));



  QGroupBox* dropBox=new QGroupBox(i18n("Drop here"), this);
  dropBox->setGeometry(20, 140, 340, 200 );

  waDropSkinWidget=new WaDropSkinWidget(dropBox);
  int x=20;
  int y=40;
  waDropSkinWidget->setGeometry(x, y, x+275, y+116 );
  dropZone = new KDNDDropZone( this, DndURL );
  connect( dropZone, SIGNAL( dropAction( KDNDDropZone* )),
	    SLOT( slotDrop( KDNDDropZone*)));
  dropfile=new Buffer(10);
  showAt(0);

}


WaSkinConfig::~WaSkinConfig() {
  delete urlList;
  delete dropfile;
}


const char* WaSkinConfig::getGroupName() {
  return i18n("Skin");
}


void WaSkinConfig::load() {
  QString localList(configGroup);
  config->setGroup(configGroup);
  
  QString s1=kapp->kde_datadir()+QString("/kmpg/skins/winamp");
  QString s2=kapp->kde_datadir()+QString("/kmpg/skins/sketchamp");
 


  localList+="skinList";
  config->readListEntry(localList,(*urlList));
  // if empty insert a few defaults

  // always append these:
  if (urlList->count() == 0) {
    urlList->append(s1);
    urlList->append(s2);
    urlList->at(0);
  }
}


void WaSkinConfig::save() {
  config->setGroup(configGroup);
  QString localList(configGroup);
  localList+="skinList";
  urlList->clear();
  int i;
  urlList->append(lineEdit->currentText());
  int n=lineEdit->count();

  // do not save more than 10 entries.
  if (n > 10) {
    n=10;
  }
  for(i=0;i<lineEdit->count();i++) {
    urlList->append(lineEdit->text(i));
  }
  config->writeEntry(localList,(*urlList));
  emit(applyEvent());
}


void WaSkinConfig::apply() {
  save();
}

 
QString WaSkinConfig::getSkinPath() {
  return lineEdit->currentText();
}

void WaSkinConfig::slotDrop(KDNDDropZone* src) {
  QStrList strlist;
  strlist = src->getURLList();
  char* dir=strlist.at(0);
  KURL aurl(dir);
  dropfile->clear();
  dropfile->append(aurl.path());  
  cout << "dropped:"<<aurl.path()<<endl;
  lineEdit->insertItem(strdup(aurl.path()),0);
  lineEdit->setCurrentItem(0);
  showAt(0);
}


void WaSkinConfig::showAt(int index) {
  const char* directory=lineEdit->text(index);
  if (directory == NULL) {
    return;
  }
  waDropSkinWidget->setMainFile((char*)directory);
}
