/*
  configuration for option of the winampSkin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <waSkinConfigOption.h>




WaSkinConfigOption::WaSkinConfigOption(const char* configGroup,
				       QWidget * parent=0,const char* name=0) 
  : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();

  

  QButtonGroup *bg = new QButtonGroup(i18n("skin not found"), this );
  QVBoxLayout *vbox = new QVBoxLayout(bg, 5);
  vbox->addSpacing( bg->fontMetrics().height() );

  QRadioButton* rb1 = new QRadioButton(i18n("use last"),bg);
  bg->insert(rb1,_WASKINCONFIGOPTION_USE_LAST);
  rb1->setMinimumSize( rb1->sizeHint() );

  QRadioButton* rb2 = new QRadioButton(i18n("ignore"),bg);
  rb2->setMinimumSize( rb2->sizeHint() );
  bg->insert(rb2,_WASKINCONFIGOPTION_IGNORE);
 
  vbox->addWidget(rb1);
  vbox->addWidget(rb2);

  bg->setButton(errorMode);
  setErrorMode(errorMode);
  bg->setGeometry(20, 40, 300, 120 );



}


WaSkinConfigOption::~WaSkinConfigOption() {
}


const char* WaSkinConfigOption::getGroupName() {
  return i18n("Options");
}


void WaSkinConfigOption::load() {
  config->setGroup(configGroup);
  errorMode=config->readNumEntry( "errorMode",_WASKINCONFIGOPTION_IGNORE);
  
}


void WaSkinConfigOption::save() {
  config->setGroup(configGroup);
  config->writeEntry("errorMode",errorMode);


  emit(applyEvent());
}


void WaSkinConfigOption::apply() {
  save();
}

 
void WaSkinConfigOption::setErrorMode(int errorMode) {
  this->errorMode=errorMode;
}
