/*
  reads raw input data from cdrom (system dependend)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __CDROMRAWACCESS_H
#define __CDROMRAWACCESS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>
#include <iostream.h>
#include <string.h>

#include "cdromToc.h"
#include "inputStream.h"


/**
   Here we have a system wrapper for raw cdrom access.
   Currently this is tested on Linux.
*/


struct cdsector{
   char sync[12],
   header[4],
   subheader[8],
   data[2324],
   spare[4];
};


class CDRomRawAccess {

  // even if you think its linux specific, it is not
  // simply make clear that the data is in the data position
  // you can always memcpy it. (but its a quick hack, I know)
  cdsector buf;
  CDRomToc* cdromToc;
  TocEntry eofEntry;
  char* dataPtr;

 public:
  CDRomRawAccess();
  virtual ~CDRomRawAccess();
  
  // overload this for new Systems
  virtual int read(int minute,int second, int frame);

  char* getBufferStart();
  int getBufferLen();

  int open(char* filename);
  int eof();
  void close();
  int isOpen();

  int isData();
  int getTocEntries();
  TocEntry* getTocEntry(int entry);
  void insertTocEntry(int minute,int second,int frame);
  int getNextTocEntryPos(int minute,int second,int frame);
  void printToc();
  int getTimeLength();


 private:
  int checkRange(cdsector* sec);
  void readToc();

  int cdfile;
  int lOpen;
  int leof;
  int buflen;
};

#endif


