/*
  class for managing byte positions and associated time positions
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __TIMESTAMP_H
#define __TIMESTAMP_H


#include <iostream.h>
#include <sys/time.h>
#include <unistd.h>





class TimeStamp {

  long key;
  int keylen;
  float avRatioGlobal;
  int audioRatioLocal;
  int audioPacketNr;
  int audioPacketNrMinor;
  
  int videoPacketNr;
  int globalPaketNr;
  
  struct timeval time;
  int vorzeichen;

  double floatTimeStamp;
  double ptsTimeStamp;
  double dtsTimeStamp;
  
  double endPtsTimeStamp;


 public:
  TimeStamp();
  ~TimeStamp();
  
  void gettimeofday();
  void set(long sec,long usec);

  void addOffset(TimeStamp* stamp);
  void addOffset(int sec,long usec);
  void copyTo(TimeStamp* dest);

  long getKey();
  int getKeyLen();
  void setKey(long key,int keylen);

  int getGlobalPacketNr();
  void setGlobalPacketNr(int nr);

  int getVorzeichen();
  void setVorzeichen(int vorzeichen);

  float getAVRatioGlobal();
  void setAVRatioGlobal(float avRatio);

  int getAudioRatioLocal();
  void setAudioRatioLocal(int avRatio);

  int getAudioPacketNr();
  void setAudioPacketNr(int nr);

  int getAudioPacketNrMinor();
  void setAudioPacketNrMinor(int nr);
 
  double getFloatTimeStamp();
  void setFloatTimeStamp(double floatTimeStamp);

  double getDTSTimeStamp();
  void setDTSTimeStamp(double dtsTimeStamp);

  double getPTSTimeStamp();
  void setPTSTimeStamp(double ptsTimeStamp);

  double getEndPTSTimeStamp();
  void setEndPTSTimeStamp(double ptsTimeStamp);
 
  void addPTSOffset(double val);

  int getVideoPacketNr();
  void setVideoPacketNr(int nr);

  void print(char* name);
  void minus(TimeStamp* stamp,TimeStamp* dest);
  void minus(int sec,long usec);
  int lessThan(TimeStamp* stamp);
  int lessThan(int sec,long usec);


  void waitForIt();
  struct timeval* getTime();

  int isPositive();
  int isNegative();

 private:
  void setTime(struct timeval* newTime);
  void normalize();


};
#endif
