/*
  class for decoders
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __DECODERCLASS_H
#define __DECODERCLASS_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "video.h"
#include "mpegPlayBitWindow.h"
#include "decoderTables.h"
#include "util.h"
#include "slice.h"
#include "proto.h"
#include "../outPlugin/mmx.h"
#include "mmxidct.h"


/* Special values for DCT Coefficients */
#define END_OF_BLOCK 62
#define ESCAPE 61


/* DCT coeff tables. */

#define LEVEL_MASK 0x03f0
#define NUM_MASK 0x000f
#define RUN_SHIFT 10
#define LEVEL_SHIFT 4
#define RUNTYPE char

class DecoderClass {

  VidStream* vid_stream;
  int lmmx;
  int zigzag_direct[256];

 public:
  DecoderClass(VidStream* vid_stream);
  ~DecoderClass();
  int decodeDCTDCSizeLum();
  int decodeDCTDCSizeChrom();
  int decodeMotionVectors();
  int decodeCBP();

  void decodeMBTypeB(int& quant,int& motion_fwd,
		     int& motion_bwd,int& pat,int& intra);

  void decodeMBTypeI(int& quant,int& motion_fwd,
		     int& motion_bwd,int& pat,int& intra);
  
  void decodeMBTypeP(int& quant,int& motion_fwd,
		     int& motion_bwd,int& pat,int& intra);


  void ParseReconBlock(int n);
  int ParseStuffing();

  void print();

 private:
  inline int decodeMBAddrInc();

  inline void decodeDCTCoeff(unsigned short int* dct_coeff_tbl,
			     unsigned RUNTYPE& run,
			     int& level) ;
 

};
#endif
