/*
 * main.c --
 *
 * Example program for mpegplay library.
 * Build with : 
  BUILD with:(if you have intel mmx)

  g++ -DINTEL -I../../yaf/include -I../.. -o mpegplay mainMpegPlay.cpp \
  libmpegplay.a ../inputPlugin/libinputplugin.a ../outPlugin/liboutplugin.a \
  ../playerPlugin/libplayerplugin.a ../../yaf/shared/audio/libaudio.a \
  -L/usr/X11R6/lib  -lX11 -lXext -lpthread

 */

#include "mpegPlugin.h"


// Includes for non plugin version
//#define _NO_PLUGIN_VERSION
#define _PLUGIN_VERSION


#ifdef _NO_PLUGIN_VERSION

int main(int argc, char** argv) {



  if (argc <= 1) {
    printf("Usage:\n\n");
    printf("%s filename\n\n",argv[0]);
    exit(0);
  }
  cout << "open -s 1"<<endl;
    
  InputStream* input=InputPlugin::createInputStream(argv[1]);
  OutputStream* output=OutPlugin::createOutputStream(_OUTPUT_LOCAL);
  cout << "open -s"<<endl;
  input->open(argv[1]);
  //loader->seek(1024*1024*364+1024*600);
  //loader->seek(1024*1024*333);

  MpegLength* mpegLength=new MpegLength(input);
  mpegLength->startCalc();
  int len=mpegLength->getLength();
  SequenceParse* sequenceParse=new SequenceParse(output);



  MpegPlayBitWindow* bitwindow=new MpegPlayBitWindow(input);
  int lfound=false;
  if(bitwindow->firstSync()==false) {
    cout << "eof"<<endl;
    exit(0);
  }
  while(input->eof()==false){
    lfound=DeMux::skip_to_start_code(bitwindow,SEQ_START_CODE);
    if (lfound==true) {
      sequenceParse->parseSeq(bitwindow,sequenceParse->getSequence());
      break;
    }
  }

  VidStream* video;
  SequenceParse::print(sequenceParse->getSequence());
  cout << "**************"<<endl;
  video= NewVidStream(bitwindow,sequenceParse);
  
  
  int cnt=0;
  // init is true
  while (input->eof()==false){
    cnt++;
    
    mpegVidRsrc(video, 0);

  }
  cout << "DestroyVidStream"<<endl;
  DestroyVidStream(video);
  cout << "end"<<endl;


}

#endif


/*

  threaded Plugin version

  ( not usefull for gprof )
*/

#ifdef _PLUGIN_VERSION

int main(int argc, char** argv) {



  if (argc <= 1) {
    printf("Usage:\n\n");
    printf("%s filename\n\n",argv[0]);
    exit(0);
  }

  //
  // The order is important !!!!
  // 1. construct
  // 2. set Output
  // 3. open input
  // 4. set input
  // 
  // you cannot set the input _before_ the output 
  // in fact you can, but this gives you a segfault!
    
  MpegPlugin* plugin=new MpegPlugin();
  OutputStream* out=OutPlugin::createOutputStream(_OUTPUT_LOCAL);
  InputStream* in=InputPlugin::createInputStream(argv[1]);

  cout << "open -s 1"<<endl;

  // The plugin does not do "open"
  in->open(argv[1]);
  cout << "open -s 2"<<endl;

  // watch the order!
  plugin->setOutputPlugin(out);
  cout << "open -s 3"<<endl;
  plugin->setInputPlugin(in);
  cout << "open -s 4"<<endl;

  plugin->play();
  int cnt=0;
  while(plugin->getStreamState() == _STREAM_STATE_NOT_EOF) {
    sleep(1);
    PluginInfo* pluginInfo=plugin->getPluginInfo();
    pluginInfo->print();
  }
  cout << "plugin eof"<<endl;
  plugin->close();

  delete plugin;
  delete in;
  delete out;
  
}

#endif

