

#ifndef __PROTO_H
#define __PROTO_H




#include "video.h"
#include "../outPlugin/outputStream.h"
#include "../inputPlugin/inputStream.h"
#include "sequenceParse.h"


/* video.c */
double ReadSysClock (void);
void PrintTimeInfo (VidStream *vid_stream);
VidStream *NewVidStream (MpegPlayBitWindow* bitwindow,SequenceParse* sequence);
void ResetVidStream (VidStream *vid);
void DestroyVidStream (VidStream *astream);
int mpegVidRsrc (VidStream *vid_stream,int first);
void videoPrint(VidStream *vid_stream);
void init_quanttables(VidStream* vid_stream);
void doPictureDisplay(VidStream* vid_stream);
void resyncToI_Frame(VidStream* vid_stream);


/* decoders.c */
void init_tables (void);
extern "C" void Fast16Dither(unsigned char *lum, 
			     unsigned char *cr,
			     unsigned char *cb,
			     unsigned char *out,
			     int rows, 
			     int cols, 
			     int mod);


/* floatdct.c */
void init_float_idct (void);
void float_idct (short* block);
extern "C" void IDCT_mmx(short *);



void ReadTimeStamp (unsigned char *inputBuffer,
		    unsigned char *hiBit,
		    unsigned long *low4Bytes);

void ReadSTD (unsigned char *inputBuffer,
	      unsigned char *stdBufferScale,
	      unsigned long *stdBufferSize);


#endif

