/*
  class for reconstruction
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __RECON_H
#define __RECON_H

#include "proto.h"
#include "video.h"
#include <iostream.h>
#include "proto.h"
#include "decoderClass.h"
#include "pictureArray.h"

#define MAX_NEG_CROP 2048
#define NUM_CROP_ENTRIES (2048+2*MAX_NEG_CROP)


class Recon {


  VidStream* vid_stream;

 public:
  Recon(VidStream* vid_stream);
  ~Recon();
  int Recon::reconstruct(int& recon_right_for,
			 int& recon_down_for,
			 int& recon_right_back,
			 int& recon_down_back,
			 int& mb_motion_forw,
			 int& mb_motion_back);
 
 private:
  int ReconIMBlock(int);
  int ReconPMBlock(int bnum,int recon_right_for,
		   int recon_down_for,int zflag);
  int ReconBMBlock(int bnum,int recon_right_back,
		   int recon_down_back,int zflag);
  
  int ReconBiMBlock(int bnum,int recon_right_for,
		    int recon_down_for,int recon_right_back,
		    int recon_down_back,int zflag);


 
};
#endif
