/*
  stores sequence header info, for reinit of stream
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __SEQUENCEPARSE_H
#define __SEQUENCEPARSE_H

#include "video.h"
#include "mpegPlayBitWindow.h"
#include "pictureArray.h"
#include "../outPlugin/outputStream.h"
#include "deMux.h"

/**
   Some vcd do only have one sequence header for the whole
   cd.
   This means we must store this info even after a seek
   which usually destroy the video stream object.
   We then can re-init the video object with the values
   we store here.
*/


class SequenceParse {

  Sequence sequence;


 public:

  SequenceParse(OutputStream* output);
  ~SequenceParse();

  static void init(Sequence* sequence,OutputStream* output);

  static int parseSeq(MpegPlayBitWindow* bitwindow,Sequence* dest);
  static void init_quanttables(Sequence* dest);
  static void copy(Sequence* dest,Sequence* src);

  void recreate(Sequence* info);
  
  Sequence* getSequence();
  static void print(Sequence* seq);
  
 private:
  static void createPictureArray(Sequence* dest);
};

#endif
