

#ifndef __VIDEO_H
#define __VIDEO_H


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <sys/time.h>





/* Define Parsing error codes. */

#define SKIP_PICTURE (-10)
#define SKIP_TO_START_CODE (-1)
#define PARSE_OK 1
#define PARSE_ERROR 0


#define SYNC_TO_CLOSED_GOP            1
#define SYNC_HAS_CLOSED_GOP           2
#define SYNC_HAS_I_FRAME_SYNC         3
#define SYNC_HAS_P_FRAME_SYNC         4
#define SYNC_HAS_FRAME_SYNC           5


/* Set ring buffer size. */

#define RING_BUF_SIZE 5

/* Macros for picture code type. */

#define I_TYPE 1
#define P_TYPE 2
#define B_TYPE 3
#define D_TYPE 4

/* Start codes. */


#define SEQ_END_CODE 0x000001b7
#define SEQ_START_CODE 0x000001b3
#define GOP_START_CODE 0x000001b8
#define PICTURE_START_CODE 0x00000100
#define SLICE_MIN_START_CODE 0x00000101
#define SLICE_MAX_START_CODE 0x000001af
#define EXT_START_CODE 0x000001b5
#define USER_START_CODE 0x000001b2
#define SEQUENCE_ERROR_CODE 0x000001b4


/* Silly Constants.... */
#define PACK_START_CODE             ((unsigned int)0x000001ba)
#define SYSTEM_HEADER_START_CODE    ((unsigned int)0x000001bb)
#define PACKET_START_CODE_MASK      ((unsigned int)0xffffff00)
#define PACKET_START_CODE_PREFIX    ((unsigned int)0x00000100)
#define ISO_11172_END_CODE          ((unsigned int)0x000001b9)
  
#define PACK_HEADER_SIZE 8
  
#define STD_AUDIO_STREAM_ID ((unsigned char) 0xb8)
#define STD_VIDEO_STREAM_ID ((unsigned char) 0xb9)
#define MIN_STREAM_ID_ID    ((unsigned char) 0xbc)
#define RESERVED_STREAM_ID  ((unsigned char) 0xbc)
#define PRIVATE_STREAM_1_ID ((unsigned char) 0xbd)
#define PADDING_STREAM_ID   ((unsigned char) 0xbe)
#define PRIVATE_STREAM_2_ID ((unsigned char) 0xbf)

// note: packetid 1 & 2 are normalized to PAKET_ID_AUDIO
// see packet.cpp
#define PAKET_ID_AUDIO      ((unsigned char) 0xc0)

#define PAKET_ID_AUDIO_1    ((unsigned char) 0xc0)
#define PAKET_ID_AUDIO_2    ((unsigned char) 0xd0)
#define PAKET_ID_VIDEO      ((unsigned char) 0xe0)

  
#define STD_SYSTEM_CLOCK_FREQ (unsigned long)90000
#define MUX_RATE_SCALE_FACTOR 50
#define MAX_STREAMS 8
#define NOT_PACKET_ID       ((unsigned char) 0xff)
#define KILL_BUFFER         ((unsigned char) 0xfe)

#define BOOLEAN int  


/* Number of macroblocks to process in one call to mpegVidRsrc. */

#define MB_QUANTUM 100

/* Macros used with macroblock address decoding. */

#define MB_STUFFING 34
#define MB_ESCAPE 35
#define GRAY_DITHER 6


#define FULL_COLOR_DITHER 7
#define NO_DITHER 8
#define GRAY256_DITHER 14
#define FULL_COLOR2_DITHER 16
#define GRAY2_DITHER 17
#define GRAY2562_DITHER 18
#define ORDERED_DITHER 9
#define IS_2x2_DITHER(a) (0)



/* External declaration of row,col to zig zag conversion matrix. */





/* Group of pictures structure. */

typedef struct GoP {
  int drop_flag;                     /* Flag indicating dropped frame. */
  unsigned int tc_hours;                 /* Hour component of time code.   */
  unsigned int tc_minutes;               /* Minute component of time code. */
  unsigned int tc_seconds;               /* Second component of time code. */
  unsigned int tc_pictures;              /* Picture counter of time code.  */
  int closed_gop;                    /* Indicates no pred. vectors to
					    previous group of pictures.    */
  int broken_link;                   /* B frame unable to be decoded.  */
  char *ext_data;                        /* Extension data.                */
  char *user_data;                       /* User data.                     */
} GoP;

/* Picture structure. */

typedef struct pict {
  unsigned int temp_ref;                 /* Temporal reference.             */
  unsigned int code_type;                /* Frame type: P, B, I             */
  unsigned int vbv_delay;                /* Buffer delay.                   */
  int full_pel_forw_vector;          /* Forw. vectors specified in full
					pixel values flag.              */
  unsigned int forw_r_size;              /* Used for vector decoding.       */
  unsigned int forw_f;                   /* Used for vector decoding.       */
  int full_pel_back_vector;          /* Back vectors specified in full 
					pixel values flag.              */
  unsigned int back_r_size;              /* Used in decoding.               */
  unsigned int back_f;                   /* Used in decoding.               */
  char *extra_info;                      /* Extra bit picture info.         */
  char *ext_data;                        /* Extension data.                 */
  char *user_data;                       /* User data.                      */
} Pict;


/* Macroblock structure. */

typedef struct macroblock {
  int mb_address;                        /* Macroblock address.              */
  int past_mb_addr;                      /* Previous mblock address.         */
  int motion_h_forw_code;                /* Forw. horiz. motion vector code. */
  unsigned int motion_h_forw_r;          /* Used in decoding vectors.        */
  int motion_v_forw_code;                /* Forw. vert. motion vector code.  */
  unsigned int motion_v_forw_r;          /* Used in decdoinge vectors.       */
  int motion_h_back_code;                /* Back horiz. motion vector code.  */
  unsigned int motion_h_back_r;          /* Used in decoding vectors.        */
  int motion_v_back_code;                /* Back vert. motion vector code.   */
  unsigned int motion_v_back_r;          /* Used in decoding vectors.        */
  unsigned int cbp;                      /* Coded block pattern.             */
  int mb_intra;                      /* Intracoded mblock flag.          */
  int bpict_past_forw;               /* Past B frame forw. vector flag.  */
  int bpict_past_back;               /* Past B frame back vector flag.   */
  int past_intra_addr;                   /* Addr of last intracoded mblock.  */
  int recon_right_for_prev;              /* Past right forw. vector.         */
  int recon_down_for_prev;               /* Past down forw. vector.          */
  int recon_right_back_prev;             /* Past right back vector.          */
  int recon_down_back_prev;              /* Past down back vector.           */
} Macroblock;

/* Block structure. */

typedef struct block {
  short int dct_recon[8][8];             /* Reconstructed dct coeff matrix. */
  short int dct_dc_y_past;               /* Past lum. dc dct coefficient.   */
  short int dct_dc_cr_past;              /* Past cr dc dct coefficient.     */
  short int dct_dc_cb_past;              /* Past cb dc dct coefficient.     */
} Block;


typedef struct sequence {
  unsigned int h_size;                         /* Horiz. size in pixels.     */
  unsigned int v_size;                         /* Vert. size in pixels.      */
  int mb_height;                               /* Vert. size in mblocks.     */
  int mb_width;                                /* Horiz. size in mblocks.    */
  int mb_size;                                 /* mb_height*mb_width-1       */
  unsigned char aspect_ratio;                  /* Code for aspect ratio.     */
  unsigned int bit_rate;                       /* Bit rate.                  */
  unsigned int vbv_buffer_size;                /* Minimum buffer size.       */
  int const_param_flag;                        /* Contrained parameter flag. */
  float picture_rate;                          /* Parse off picture rate code*/
  unsigned char intra_quant_matrix[8][8];      /* Quantization matrix for
						  intracoded frames.         */
  unsigned char non_intra_quant_matrix[8][8];  /* Quanitization matrix for 
						  non intracoded frames.     */
  char *ext_data;                              /* Extension data.            */
  char *user_data;                             /* User data.                 */
  struct OutputStream* output;
  struct PictureArray* pictureArray;
} Sequence;

/* Video stream structure. */
typedef struct vid_stream {
  Sequence sequence;                           /* Sequence info in stream    */
  GoP group;                                   /* Current group of pict.     */
  Pict picture;                                /* Current picture.           */
  Macroblock mblock;                           /* Current macroblock.        */
  Block block;                                 /* Current block.             */



  int right_for,down_for;                      /* From ReconPMBlock, video.c */
  int right_half_for, down_half_for;

/* Brown - end of added variables */


  struct MpegPlayBitWindow* bitwindow;
  struct DecoderClass* decoderClass;
  struct Recon* recon;
  struct Packet* packet;
  struct MotionVector* motionVector;
  struct Slice* slice;                         /* Current slice.             */
  struct TimeStamp* startOfPicStamp;
  int syncState;
} VidStream;   



/* Declaration of global display pointer. */



extern int qualityFlag;




extern int gXErrorFlag;




#endif /* video.h already included */


