/*
  mpg I video/audio player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __MPGPLUGIN_H
#define __MPGPLUGIN_H

#include "../mpegplay/mpegPlugin.h"
#include "../splay/splayPlugin.h"
#include "packetArray.h"

#define _INSERT_NO            0
#define _INSERT_VIDEO         1
#define _INSERT_AUDIO         2
#define _INSERT_ALL           3



class MpgPlugin : public PlayerPlugin {
  
  SplayPlugin* splayPlugin;
  MpegPlugin* mpegplayPlugin;


  SequenceParse* sequenceParse;

  BufferInputStream* splayInput;
  BufferInputStream* mpegplayInput;

  int globalPacketCnt;
  int audioPacketCnt;
  int videoPacketCnt;
  int lastVideoCnt;


  PacketArray* audioPacketArray;
  PacketDescription* audioPacket;

  int lmpegplayRun;
  int lsplayRun;

  MpegLength* mpegLength;
  int lCalcLength;

  int downSampleFlag;
  int monoFlag;
  int lInit;
  int first;
  int requiredFillGrade;

 public:
  MpgPlugin();
  ~MpgPlugin();

  void decoder_loop();
  int seek(int second);

  void config(char* key, char* value);



 private:

  TimeStamp* timeStamp;
  TimeStamp* timeStampVirtual;
  int getSongLength();
 
  void startSubPlugins();
  void removeSubPlugins();
  
  int firstSync(Packet* packet);
  void get_more_data(Packet* packet);
  void appendToBuffer(char* ptr,int bytes,unsigned char packetID);
  void shutDownSPlay();
  void restartSPlay();

  void shutDownMPEGPlay();
  void restartMPEGPlay();
  void resetCounters();

};
#endif

