


#include "dither.h"


#define doRow(row,Lum)  *row++=(local_r_2_pix[Lum] | \
 local_g_2_pix[Lum] | local_b_2_pix[Lum]);


/*
#define doRow(row,Lum)  { *row=local_r_2_pix[Lum]; \
                          *row<<=8; \
                          *row|=local_g_2_pix[Lum]; \
                          *row<<=8; \
                          *row++ |= local_b_2_pix[Lum]; \
                        }
*/                         




void dither32(unsigned char* lum,
	      unsigned char* cr,
	      unsigned char* cb,
	      unsigned char* out,
	      int rows,
	      int cols,
	      int mod,
	      PIXVAL* r_2_pix,
	      PIXVAL* g_2_pix,
	      PIXVAL* b_2_pix,
	      TABTYPE* Cr_r_tab,
	      TABTYPE* Cr_g_tab,
	      TABTYPE* Cb_g_tab,
 	      TABTYPE* Cb_b_tab,
	      TABTYPE* L_tab) {



    int L;
    int n;
    int rowWork;
    int colWork;
    
    unsigned int *row1, *row2;
    unsigned char *lum2;
    PIXVAL* local_r_2_pix;
    PIXVAL* local_g_2_pix;
    PIXVAL* local_b_2_pix;

    // from loki local cache enhacement
    TABTYPE* colortab=Cr_r_tab;
    row1 = (unsigned int *)out;

    row2 = row1+cols;
    lum2 = lum+cols;

    // because the width/height are a multiply of a macroblocksize
    // cols/rows always are even
    colWork=cols>>1;
    rowWork=rows>>1;
    mod=cols+mod;

   while(rowWork--) {
      n=colWork;
      while(n--) {

        local_r_2_pix=r_2_pix+Cr_r_tab[*cr];
        local_g_2_pix=g_2_pix+Cr_g_tab[*cr++] + Cb_g_tab[*cb];
        local_b_2_pix=b_2_pix+Cb_b_tab[*cb++];

        L = L_tab[*lum++];
	doRow(row1,L)

        L = L_tab[*lum++];
	doRow(row1,L)

        L = L_tab [*lum2++];
	doRow(row2,L)

        L = L_tab [*lum2++];
	doRow(row2,L)


      }
      row2 += mod;
      lum += cols;
      lum2 += cols;
      row1 += mod;

    }

}

