/*
  interpolates two timestamps for corresponding to a given bytelength
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "interpolateTimeStamp.h"



InterpolateTimeStamp::InterpolateTimeStamp() {
  newEnd=new TimeStamp();
}


InterpolateTimeStamp::~InterpolateTimeStamp() {
  delete newEnd;
}


void InterpolateTimeStamp::calculateEnd(TimeStamp* start,
					TimeStamp* end,
					TimeStamp* target,
					int byteLengthNew,
					int byteLengthOld) {

  float startAudio=start->getAudioPacketNr();
  float startVideo=start->getVideoPacketNr();

  float endAudio=end->getAudioPacketNr();
  float endVideo=end->getVideoPacketNr();

  float audioDiff=endAudio-startAudio;
  float videoDiff=endVideo-startVideo;

  float newAudioEndRel=((float)byteLengthNew*audioDiff)/(float)byteLengthOld;
  float newVideoEndRel=((float)byteLengthNew*videoDiff)/(float)byteLengthOld;

  float newAudioEnd=startAudio+newAudioEndRel;
  float newVideoEnd=startVideo+newVideoEndRel;
 
 
  newEnd->setAudioPacketNr(newAudioEnd);
  newEnd->setVideoPacketNr(newVideoEnd);

  target->setAudioPacketNr(newAudioEnd);
  target->setVideoPacketNr(newVideoEnd);
   
  


}



TimeStamp* InterpolateTimeStamp::getNewEnd() {
  return newEnd;
}
