/*
  base class for the player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __PLAYERPLUGIN_H
#define __PLAYERPLUGIN_H

#include <pthread.h>
#include <errno.h>
#include "../inputPlugin/inputPlugin.h"
#include "../outPlugin/outPlugin.h"
#include "pluginInfo.h"


#define _STREAM_STATE_EOF     1
#define _STREAM_STATE_NOT_EOF 2



/**
   Here is the base class for the player plugin.
   we can set the output of the player, and the input.
   <p>
   This class offer you a thread which you have to use
   in derived class for the decoding work.
   <p>
   All calls to your decoder goes through this class
   which must make sure that there are no races.
*/

class PlayerPlugin {

 public:
  
  PlayerPlugin();
  virtual ~PlayerPlugin();

  
  virtual void close();
  virtual void pause();
  virtual void play();
  virtual int seek(int second);


  virtual void setOutputPlugin(OutputStream* output);

  // This method can only be called _once_ after a "close"
  virtual int setInputPlugin(InputStream* input);
  virtual void config(char* key, char* value);
  virtual int getStreamState();
  PluginInfo* getPluginInfo();

  // never use this!
  void* idleThread();

 protected:
  

  void decoderLock();
  void decoderUnlock();

  void workLock();
  void workUnlock();

  // this is the method to override in your decoder
  virtual void decoder_loop();




  OutputStream* output;
  InputStream* input;

  pthread_t tr;
  pthread_mutex_t decoderMut; 
  pthread_mutex_t workMut; 
  pthread_mutex_t decoderChangeMut; 
  pthread_cond_t decoderCond;


  int lDecoderLoop;
  int lCreatorLoop;
  int linDecoderLoop;
  int lDecode;
  int leof;
  int lhasLength;
  int lAutoPlay;

  PluginInfo* pluginInfo;
};

#endif

