/*
  splay player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "splayPlugin.h"



SplayPlugin::SplayPlugin() {
  downSampleFlag=false;
  monoFlag=false;
  server=NULL;
  lnoLength=false;
}


SplayPlugin::~SplayPlugin() {
}


// here we can config our decoder with special flags
void SplayPlugin::config(char* key, char* value) {
  if (strcmp(key,"-m")==0) {
    monoFlag=true;
  }
  if (strcmp(key,"-2")==0) {
    downSampleFlag=true;
  }
  if (strcmp(key,"-c")==0) {
    lnoLength=true;
  }
  PlayerPlugin::config(key,value);
}

// we have a problem with splay, it reads the length out of
// the stream
// if we would always make this withouth the swicht
// test we would block the video player
// so we must test.
void SplayPlugin::doInit(int canReadStream) {
  // ok first initilisation
  cout << "*************** initialize"<<endl;
  if (canReadStream==false) {
    return;
  }
  server->initialize();

  int bps=server->getbitrate();
  if (server->isXingVBR()) {
    // someday I must find out how to convert from big to little endian
    bps=0;
  }
  if (lnoLength==false) {
    pluginInfo->setLength(getSongLength());
    output->writeInfo(pluginInfo);
  }
  lhasLength=true;
  cout << "*************** initialize      end"<<endl;
  lfirst=false;
}


void SplayPlugin::decoder_loop() {
  int lInit=false;

  lfirst=true;

  if (input == NULL) {
    cout << "SplayPlugin::decoder_loop input is NULL"<<endl;
    exit(0);
  }
  if (output == NULL) {
    cout << "SplayPlugin::decoder_loop output is NULL"<<endl;
    exit(0);
  }
  // init decoder
  server = new Mpegtoraw(input, output);
  server->setdownfrequency(downSampleFlag);
  server->setforcetomono(monoFlag);


  // ok first initilisation
  if (lnoLength==false) {
    doInit(true);
  }
    


  // start decoding
  while(lDecoderLoop && lCreatorLoop) {
    if (pthread_mutex_trylock(&decoderChangeMut) == EBUSY) {
      pthread_cond_wait(&decoderCond,&decoderMut);
      continue;
    }
    pthread_mutex_unlock(&decoderChangeMut);
    if (lDecode) {
      if (lInit==false) {
	if (lfirst==true) {
	   doInit(true);
	}
	if (server->run(-1) == false) {
	  if (server->geterrorcode() == SOUND_ERROR_FINISH){
	    lDecoderLoop=false;
	    leof=true;
	  }
	  continue;
	}
	lInit=true;
      }
      server->run(5);

      if (server->geterrorcode() == SOUND_ERROR_FINISH){
	lDecoderLoop=false;
	leof=true;
      } else {
	if (server->geterrorcode() != SOUND_ERROR_OK) {
	  cout << "reinit because error"<<endl;
	  lInit=false;
	}
      }
      
    } else {
      pthread_cond_wait(&decoderCond,&decoderMut);
   }
  }
  // remove decoder

  server->clearbuffer();
  delete server;
  server = NULL;
  cout << "audioFlush -s"<<endl;
  output->audioFlush();
  cout << "audioFlush -e"<<endl;
  pthread_mutex_unlock(&decoderMut);
}

// splay can seek in streams
int SplayPlugin::seek(int second) {
  decoderLock();
  // small hack.
  // splay gets length while streaming
  if (lDecode) {
    while(lhasLength==false) {
      cout << "waiting for length info"<<endl;
      usleep(100000);
    }
  }

  int length=getSongLength();
  int totalframes;
  float jumpFrame=0.0;
  // race condition: 
  if (server != NULL) {
    totalframes=server->gettotalframe();
    if (totalframes > 0) {
      jumpFrame = ((float)second/(float)length)*(float)totalframes;

    }
    server->clearbuffer();
    server->setframe((int)jumpFrame);
  }
  decoderUnlock();
  return true;
}


int SplayPlugin::getSongLength() {
  int back=0;
  
  if (server != NULL){
    float totalframes=server->gettotalframe();
    float pcm=server->getpcmperframe();
    float wavfilesize=(totalframes*pcm);
    float frequence=(float)server->getfrequency();
    if (frequence != 0) {
      back=(int)(wavfilesize/frequence);
    }
  }
  return back;
}






