/*
  this class controls the different decoders.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <amplifier/amplifier.h>

Amplifier::Amplifier() {
}


Amplifier::~Amplifier() {
}


GenericPlayer* Amplifier::createPlayer(int playerType) {

  DecoderID* decoderID=Amplifier::createDecoderID(playerType,0,NULL);
  GenericPlayer* back=Amplifier::createPlayer(decoderID);

  delete decoderID;
  return back;
}

/**
   expect a decoder id created with createStandardDecoderID.
*/
GenericPlayer* Amplifier::createPlayer(DecoderID* addDecoderID) {
  int id=addDecoderID->getID();
  GenericPlayer* player=new GenericPlayer();
  DataGenerator* generator;
  DecoderID* decoderID;

  // _we_ know what we are doing, you not.
  decoderID=new DecoderID(id,0,NULL);
  int argn=addDecoderID->getArgn();
  int i;
  for(i=0;i<argn;i++) {
    decoderID->addArgs(addDecoderID->getArgs(i));
  }
  if (id != _IMAGE_VIEWER) {
    generator=Amplifier::createYafGenerator(decoderID);
  } else {
    generator=new ImageGenerator();
  }
  
  player->setDataGenerator(generator);
  // decoder id becomes a member variable!
  generator->setDecoderId(decoderID);

  return player;
}


DecoderID* Amplifier::createStandardDecoderID(int playerTyp) {
  return Amplifier::createDecoderID(playerTyp,0,NULL);
}


YafGenerator* Amplifier::createYafGenerator(DecoderID* decoderID) {
  int id=decoderID->getID();

  int bufferSize=1024*1024;
  if (id == _MPEG_VIDEO_DECODER) {
    bufferSize=1024*16;
  }
  
  // decoder is yaf

  YafGenerator* generator=new YafGenerator(bufferSize);


  int argn=decoderID->getArgn();
  int i;
  for(i=0;i<argn;i++) {
    generator->addArgument(decoderID->getArgs(i));
  }

  if (argn == 0) {
    cout << "No executable for type : " << id << "registered !"<<endl;
    return NULL;
  }
  generator->startDecoder();
  // now we connect them:
  return generator;
}



DecoderID* Amplifier::createDecoderID(int id,int argn, char** args) {
  AmplifierConfig* config=new AmplifierConfig();
  char** executableArgs=config->getExecutable(id);
  DecoderID* back=new DecoderID(id,0,NULL);

  // calculate entries in array
  int executableArgn=0;
  while(executableArgs[executableArgn] != NULL) {
    executableArgn++;
  }

  int i;
  for(i=0;i<executableArgn;i++) {
    back->addArgs(executableArgs[i]);
  }
  
  for(i=0;i<argn;i++) {
    back->addArgs(args[i]);
  }
  delete config;
  return back;
}







    

  
