/*
  stores all known streams
  Copyright (C) 1999 Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/deviceConfig.h>


DeviceConfig::DeviceConfig() {
  infoStream=new InfoStream();
  audioStream=new AudioStream();
  videoStream=new VideoStream();
  streamProducer=NULL;
  setId(__STREAM_CONTAINER);
}


DeviceConfig::~DeviceConfig() {
  delete infoStream;
  delete audioStream;
  delete videoStream;
}


void DeviceConfig::setAudioStream(AudioStream* aAudioStream) {
  aAudioStream->copyTo(audioStream);
}


AudioStream* DeviceConfig::getAudioStream() {
  return audioStream;
}


void DeviceConfig::setVideoStream(VideoStream* aVideoStream) {
  aVideoStream->copyTo(videoStream);
}


VideoStream* DeviceConfig::getVideoStream() {
  return videoStream;
}


void DeviceConfig::setInfoStream(InfoStream* aInfoStream) {
  aInfoStream->copyTo(infoStream);
}


InfoStream* DeviceConfig::getInfoStream() {
  return infoStream;
}


void DeviceConfig::copyTo(Stream* aConfig) {
  int id=aConfig->getId();
  if (id != __STREAM_CONTAINER) {
    cout << "fatal error: cannot copy _STREAM_CONTAINER to id:"<<id<<endl;
    exit(-1);
  }
  
  DeviceConfig* aDeviceConfig=(DeviceConfig*)aConfig;

  aDeviceConfig->setVideoStream(getVideoStream());
  aDeviceConfig->setAudioStream(getAudioStream());
  aDeviceConfig->setInfoStream(getInfoStream());
  aDeviceConfig->setStreamProducer(getStreamProducer());
  Stream::copyTo(aConfig);
  
}


void DeviceConfig::print() {
  getVideoStream()->print();
  getAudioStream()->print();
  getInfoStream()->print();
  cout << "deviceConfig - print [START]"<<endl;
  printf("audioStream %p\n",getAudioStream());
  printf("videoStream %p\n",getVideoStream());
  printf("infoStream %p\n",getInfoStream());
  Stream::print();
  cout << "deviceConfig - print [END]"<<endl;
}


void* DeviceConfig::getStreamProducer() {
  return streamProducer;
}


void DeviceConfig::setStreamProducer(void* streamProducer) {
  this->streamProducer=streamProducer;
}


void DeviceConfig::forward() {
  audioStream->forward();
  videoStream->forward();
  infoStream->forward();
  Stream::forward();
}


int DeviceConfig::isValid() {
  cout << "strange call to DeviceConfig::isValid"<<endl;
  return true;
}


void DeviceConfig::addLock() {
  audioStream->addLock();
  videoStream->addLock();
  infoStream->addLock();
}


void DeviceConfig::removeLock() {
   audioStream->removeLock();
   videoStream->removeLock();
   infoStream->removeLock();
}



