/*
  stores deviceConfigs.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __DEVICECONFIGARRAY_H
#define __DEVICECONFIGARRAY_H

#include <deviceConfig/deviceConfig.h>

#define _MAX_ENTRIES 10

class DeviceConfigArray {

 public:
  DeviceConfigArray();
  ~DeviceConfigArray();

  void clear();
  
  int getEntries();
  void setEntries(int entries);

  struct DeviceConfig* getDeviceConfigAt(int pos);
  void setDeviceConfigAt(int pos,struct DeviceConfig* buf);

  int getMaximumMemChunkLen();
  int getMaximumMemChunkPos();
  
  void print();

 private:
  struct DeviceConfig* confArray[_MAX_ENTRIES];
  int entries;

};

#endif


