/*
  stores the volume information for a stream
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <deviceConfig/info/volumeInfo.h>



VolumeInfo::VolumeInfo(){
  setValid(true);
  leftVolume=100.0;
  rightVolume=100.0;
}


VolumeInfo::~VolumeInfo() {
}



void VolumeInfo::setVolume(float percent) {
  setLeftVolume(percent);
  setRightVolume(percent);
}


void VolumeInfo::setLeftVolume(float percent) {
  if (percent != leftVolume) {
    setChange(true);
  }
  leftVolume=percent;
}


float VolumeInfo::getLeftVolume() {
  return leftVolume;
}


void VolumeInfo::setRightVolume(float percent) {
  if (percent != rightVolume) {
    setChange(true);
  }
  rightVolume=percent;
}


float VolumeInfo::getRightVolume() {
  return rightVolume;
}


int VolumeInfo::equals(VolumeInfo* aInfo) {
  if (aInfo == NULL) return false;

  if (aInfo->getLeftVolume() != leftVolume) {
    return false;
  }
  if (aInfo->getRightVolume() != rightVolume) {
    return false;
  }
  return true;
} 


void VolumeInfo::copyTo(VolumeInfo* aInfo) {
  if (aInfo == NULL) return;

  aInfo->setLeftVolume(getLeftVolume());
  aInfo->setRightVolume(getRightVolume());
  aInfo->setChange(getChange());
  
} 
 


void VolumeInfo::print() {
  cout << "VolumeInfo-begin-"<<endl;
  cout << " Lvol: "<<getLeftVolume()
       << " Rvol: "<<getRightVolume()<< endl;
  cout << "VolumeInfo-end-"<<endl;
}
