/*
  encapsulates memory with a callback to a ringbuffer
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __MEMCHUNK_H
#define __MEMCHUNK_H

#include <pthread.h>

#include <deviceConfig/mem/memManager.h>
#include <iostream.h>

/**
  The MemChunk is continous memory. You can add locks
  to the memory. If the lockCounter reaches zero a 
  callback to the ringbuffer is executed. The ringbuffer
  then deletes the memory.
  <p>
  This class has developed to a bad hack.
  It needs a clean solution.
  The main goal of this class is to have graph wide
  shared memory.
  This needs a clean interface where devices
  can register itsself an then get detach messages.
  For now we live with this hack.

*/

class MemChunk {

  char* ptr;
  int len;
  int nLocks;
  struct MemManager* memManager;
  int lInternalMemManager;
  int lConfirmed;
  int size;
  pthread_mutex_t mut;
  pthread_cond_t unlockCond;
  
 public:
  MemChunk(struct MemManager* memManager,int size);
  MemChunk(int size);
  ~MemChunk();
  
  void resize(int size);
  int getSize();

  char* getPtr();
  void setPtr(char* ptr);

  int getLen();
  void setLen(int len);


  int getLocks();
  void resetLocks();

  void addLock();
  void removeLock();

  void print();

  
  // we store here how much space is left in the shared memory
  int overflowDanger();


  // This can be called by a thread. The thread blocks until the
  // memChunk is completly unlocked!
  void waitForUnlock();

  void switchBackToInternalMemManager();

 private:
  void init(struct MemManager* memManager,int size);
};

#endif
