#ifndef QWAUDIO_P_H
#define QWAUDIO_P_H

#include <pthread.h>
#include <iostream.h>
#include <qsocknot.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// fixes INT32 bug, which is defined in qt as well

#ifndef __alpha 
#define __alpha
#endif

#ifdef HAVE_AUDIO_AUDIOLIB_H
#include <audio/audiolib.h>


#define _HAVE_NAS  
#else
#ifdef HAVE_AUDIOLIB_H
#include <audiolib.h>
#define _HAVE_NAS  
#endif
#endif


#ifndef _HAVE_NAS
// #warning NAS Support not included. Using dummy class. 
#endif


#include <signal/toolkit/eventQueue.h>
#include <devices/nodeDevice.h>
#include <util/ringBuffer.h>


#define RINGBUFFERSIZE	32768
#define LOW_WATER	RINGBUFFERSIZE / 4
#define HIGH_WATER	RINGBUFFERSIZE - LOW_WATER 


class QwAuServer : public QObject {
  Q_OBJECT

 private:
  QSocketNotifier* sn;
  pthread_mutex_t changeMut;

#ifdef _HAVE_NAS
  // Data delivered by the thread
  AuFlowID auFlowID;
  AuServer* nas;
#endif

  int element;
  RingBuffer* ringBuffer;
  MemChunk* gmemWrite;
  MemChunk* gmemRead;

 public:
  QwAuServer();
  ~QwAuServer();

  int isOpen();
  int open(char* display);
  void close();

  void lockServer();
  void unlockServer();

#ifdef _HAVE_NAS
  void sendData(AuUint32 numBytes);
  //non threaded send to nas server
  int sendDataToNASServer(AuFlowID auFlowID,int element,int bytes);
  AuServer* getAuServer();
#endif

  //threaded write
  int writeToRingBuffer(char* buf,int len);
  int getFillgrade();
  void clear();

 public slots:
  void dataReceived();

 protected:
  void timerEvent(QTimerEvent*);
};

#endif

