/*  
  start external programms an connect the stdin/stdout slots  
  Copyright (C) 1999  Martin Vogt,Christian Czezatke

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

*/


/*

  This file was originally written by Christian Czezatke, but
  was modified to abstract the signal mechanism (gtk port)

*/


#ifndef __YAFPROCESS_H
#define __YAFPROCESS_H

#include <sys/types.h> // for pid_t
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <qstrlist.h>
#include <qobject.h>
#include <qsocknot.h>
#include <iostream.h>



class YafProcess : public QObject {
  Q_OBJECT

public:


  enum Communication { NoCommunication = 0, Stdin = 1, Stdout = 2, Stderr = 4,
		       AllOutput = 6, All = 7 };

  enum RunMode { DontCare, NotifyOnExit, Block };

  YafProcess();
  virtual ~YafProcess();
  bool setExecutable(const char *proc);
  YafProcess &operator<<(const char *arg);
  void clearArguments();
  virtual bool start(RunMode  runmode = NotifyOnExit, 
		     Communication comm = NoCommunication);
  virtual bool kill(int signo = SIGTERM);

  bool isRunning();
  pid_t getPid();
  bool normalExit();
  int  exitStatus(); 
  bool writeStdin(char *buffer, int buflen);
  bool closeStdin();

  

  signals: 

  void processExited(YafProcess *proc);
  void receivedStdout(YafProcess *proc, char *buffer, int buflen);
  void receivedStderr(YafProcess *proc, char *buffer, int buflen);
  void wroteStdin(YafProcess *proc);


protected slots:

  void slotChildOutput(int fdno);
  void slotChildError(int fdno);
  void slotSendData(int dummy);

protected:

  QStrList arguments;
  RunMode run_mode;
  bool runs;

  pid_t pid;
  int status;
  virtual int setupCommunication(Communication comm);
  virtual int commSetupDoneP();
  virtual int commSetupDoneC();
  virtual void processHasExited(int state);
  virtual void commClose();
  

  int out[2], in[2], err[2];
  /* the socket descriptors for stdin/stdout/stderr */


  QSocketNotifier *innot, *outnot, *errnot;
  Communication communication;		
  int childOutput(int fdno);
  int childError(int fdno);
   
  char *input_data;  // the buffer holding the data
  int input_sent;    // # of bytes already transmitted
  int input_total;   // total length of input_data

  friend class YafProcessController;

  char childOutputBuffer[1024];
  char childErrorBuffer[1024];

};

#endif
