/*
  implements a blocking file descriptor
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <util/bindSocket.h>



BindSocket::BindSocket(char* filename) {
  buffer=new Buffer(50);
  buffer->append(filename);

  bindSocket=-1;
  dataSocket=-1;
}


BindSocket::~BindSocket() {
  unlink(buffer->getData());
  delete buffer;
  if (bindSocket > 0) {
    close(bindSocket);
  }
  if (dataSocket > 0) {
    close(dataSocket);
  }
}



int BindSocket::bind() {
  int back;
  
  back=::socket(AF_UNIX,SOCK_STREAM,0);
  if (back < 0) {
    perror("socket-Socket create");exit(1);
  }
  
  unsigned int i=0;
  sockad.sun_family=AF_UNIX;

  while(i<strlen(buffer->getData())) {
        sockad.sun_path[i]=buffer->getData()[i];
        i++;
  }
  sockad.sun_path[i]=0;
  cout << "binding socket:"<<buffer->getData()<<endl;
  if (::bind(back,(sockaddr*)&sockad,strlen(buffer->getData())+2)<0) {
    perror("bind");exit(1);
  }
  if (listen(back,1) < 0) {
    perror("listen");exit(1);
  }
  if (fcntl(back,F_SETFD,true) < 0) {
    perror("fcntl create");exit(1);
  }
  bindSocket=back;
  return back;
}

  

int BindSocket::accept() {
  fd_set readfds;
  FD_ZERO(&readfds);
  FD_SET(bindSocket,&readfds);
  struct timeval timeout;
  timeout.tv_sec = 1;
  timeout.tv_usec = 0;
  int ret=select(bindSocket+1,&readfds,NULL,NULL,&timeout);
  if (ret <= 0) {
    return 0;
  }
  
  dataSocket=::accept(bindSocket,(sockaddr*)&partn_ad,&partn_len);
  if (dataSocket < 0) {
    perror("BindSocket::accept");
  }

  return dataSocket;
}


char* BindSocket::getSocketName() {
  return buffer->getData();
}



int BindSocket::read(char* buf, int max) {
  int back;

  back=::recv(dataSocket,buf,max,0);
  if (back == -1) {
    printf("Socket error mit :%d fd:%d buf:%p len:%d\n",
	   errno,dataSocket,buf,max);
    perror("socket:");
  }
  return back;
}
  
 
int BindSocket::write(char* buf, int max) {
  return ::send(dataSocket,buf,max,0);
}


int BindSocket::isOpen() {
  if (bindSocket < 0) {
    return false;
  }
  if (dataSocket < 0) {
    return false;
  }
  return true;
}
  
