/*
  a thread safe ring buffer with support for locked memory
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <util/ringBufferNT.h>


RingBufferNT::RingBufferNT(int ringBufferSize, int minLinBufferSize):
RingBuffer(ringBufferSize,minLinBufferSize) {
  
  int i;

  for (i=0;i<_MAX_MEM_CHUNKS;i++) {
    memChunkArray[i]=GarbageCollector::createMemChunk(this,0);
  }
  lockPos=0;
  freePos=0;
  lockCounter=0;
  canRead=ringBufferSize;
}


RingBufferNT::~RingBufferNT() {
  int i;

  for (i=0;i<_MAX_MEM_CHUNKS;i++) {
    GarbageCollector::deleteMemChunk(memChunkArray[i]);
  } 
}


MemChunk* RingBufferNT::requestMemChunk(int preferredSize) {
  MemChunk* memChunk;

  if (lockCounter==_MAX_MEM_CHUNKS) {
    cout << "RingBufferNT::requestMemChunk out of chunks"<<endl;
    exit(-1);
  }
  memChunk=memChunkArray[freePos];
  memChunk->resetLocks();
  getReadArea(memChunk,preferredSize);
  return memChunk;
}


// its is thread safe because of the calls by the memChunk
void RingBufferNT::lockMemChunk(MemChunk* aChunk) {
  MemChunk* memChunk;

  memChunk=memChunkArray[freePos];
  forwardReadPtr(memChunk->getLen());
  canRead=canRead-memChunk->getLen();
  
  lockCounter++;
  freePos++;
  if (freePos == _MAX_MEM_CHUNKS) {
    freePos=0;
  }
}

int RingBufferNT::overflowDanger() {

  if (canRead < 1024) {
    return true;
  }
  return false;
}

   
// its is thread safe because of the calls by the memChunk
void RingBufferNT::unlockMemChunk(MemChunk* aChunk) {
  MemChunk* memChunk;

  memChunk=memChunkArray[lockPos];
  while((lockPos != freePos) && (memChunk->getLocks()==0)) {
    forwardLockPtr(memChunk->getLen());
    canRead=canRead+memChunk->getLen();
   
    lockPos++;
    lockCounter--;
    if (lockPos == _MAX_MEM_CHUNKS) {
      lockPos=0;
    }
    memChunk=memChunkArray[lockPos];
  }
}











