//
// /home/ms/sidplay/qtsidplay/RCS/MainDialog.cpp,v
//


#include <qbitmap.h>
#include <qdict.h>
#include <qfiledlg.h>
#include <qmsgbox.h>
#include <qstring.h>

#include "MainDialog.h"
#define Inherited MainDialogData


#include "AudioDialog.h"
#include "EmuDialog.h"
#include "FilterDialog.h"
#include "GlobalExt.h"
#include "MixerDialog.h"
#include "StilDialog.h"
#include "WaveViewDialog.h"

#include "btnstate.h"

#include "images/prev.xpm"
#include "images/stop.xpm"
#include "images/play.xpm"
#include "images/pause.xpm"
#include "images/ff.xpm"
#include "images/next.xpm"

#include "images/stop_p.xpm"
#include "images/pause_p.xpm"
#include "images/ff_p.xpm"

#include "images/prev_l.xpm"
#include "images/stop_l.xpm"
#include "images/play_l.xpm"
#include "images/pause_l.xpm"
#include "images/ff_l.xpm"
#include "images/next_l.xpm"

#include "images/prev_l_p.xpm"
#include "images/stop_l_p.xpm"
#include "images/play_l_p.xpm"
#include "images/next_l_p.xpm"

#include "images/mainicon.xpm"

#include <sidplay/player.h>

extern sidTune mySidTune;
extern sidTuneInfo mySidTuneInfo;

extern int playbackState;
extern bool isReadyToPlay;

QPixmap* myMainIcon;

// --------------------------------------------------------------------------

QFileDialog* myFileDlg;

AudioDialog* myAudioDlg;
EmuDialog* myEmuDlg;
FilterDialog* myFilterDlg;
MixerDialog* myMixerDlg;
StilDialog* myStilDlg;
WaveViewDialog* myWaveViewDlg;

#include <kapp.h>

extern KApplication *thisapp;

MainDialog::MainDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "KSidplayer" );
	setFixedSize(width(),height());
	
	myMainIcon = new QPixmap((const char**)mainicon_xpm);
	setIcon(*myMainIcon);

    infoField->setText("");
	
    QPopupMenu *file = new QPopupMenu;
    CHECK_PTR( file );
    file->insertItem( i18n("&Open"), this, SLOT(open()), CTRL+Key_O );
    file->insertItem( i18n("&Save as"), this, SLOT(saveAs()), CTRL+Key_S );
    file->insertSeparator();
    file->insertItem( i18n("E&xit"), this, SLOT(quit()), CTRL+Key_Q );

    QPopupMenu *config = new QPopupMenu;
    CHECK_PTR( config );
	config->insertItem( i18n("Audio"), this, SLOT(openAudioDialog()) );
	config->insertItem( i18n("Emulator"), this, SLOT(openEmulatorDialog()) );
	config->insertItem( i18n("Filter"), this, SLOT(openFilterDialog()) );
	config->insertItem( i18n("Mixer"), this, SLOT(openMixerDialog()) );

	extra = new QPopupMenu;
	CHECK_PTR( extra );
	extra->setCheckable(true);
	stilID = extra->insertItem( i18n("STIL Info"), this, SLOT(toggleStilDialog()) );
	waveViewID = extra->insertItem( i18n("Oscilloscope"), this, SLOT(openWaveViewDialog()) );

    QPopupMenu *help = new QPopupMenu;

    CHECK_PTR( help );
    help->insertItem( i18n("&Help"), this, SLOT(invokeHelp())); 
    help->insertItem( i18n("SIDPLAY"), this, SLOT(about()), CTRL+Key_H );
    help->insertItem( i18n("Qt"), this, SLOT(aboutQt()) );

    menu = new QMenuBar( this );
    CHECK_PTR( menu );
    menu->insertItem( i18n("&File"), file );
    menu->insertItem( i18n("&Config"), config );
    menu->insertItem( i18n("&Extra"), extra );
    menu->insertSeparator();
    menu->insertItem( i18n("&About"), help );
	
	myFileDlg = new QFileDialog(0,0,false);
	myFileDlg->setCaption(i18n("Sidtune Selection"));
	myFileDlg->setIcon(*myMainIcon);
	connect(myFileDlg,SIGNAL(fileHighlighted(const char*)),this,SLOT(playFile(const char*)));
	
	myAudioDlg = new AudioDialog();

	myEmuDlg = new EmuDialog();
	myFilterDlg = new FilterDialog();
    myFilterDlg->connect(myEmuDlg,SIGNAL(sendEmuFilterFlag(bool)),myFilterDlg,SLOT(receiveFilterFlag(bool)));
    myEmuDlg->connect(myFilterDlg,SIGNAL(sendFilterFlag(bool)),myEmuDlg,SLOT(receiveEMUfilterFlag(bool)));

	myMixerDlg = new MixerDialog();
	
	myStilDlg = new StilDialog();
	
	myWaveViewDlg = new WaveViewDialog();
	
	prevBtn = new PicButton( this, "PicButton_1" );
	prevBtn->setGeometry( 140, 39, 36, 24 );
	connect( prevBtn, SIGNAL(pressed()), SLOT(prevSongPressed()) );
	connect( prevBtn, SIGNAL(released()), SLOT(prevSongReleased()) );
	prevBtn->setAutoRepeat( true );
	prevBtn->setAutoResize( false );

	stopBtn = new PicButton( this, "PicButton_2" );
	stopBtn->setGeometry( 185, 39, 36, 24 );
	connect( stopBtn, SIGNAL(pressed()), SLOT(stopSongPressed()) );
	connect( stopBtn, SIGNAL(released()), SLOT(stopSongReleased()) );
	stopBtn->setAutoRepeat( false );
	stopBtn->setAutoResize( false );

	playBtn = new PicButton( this, "PicButton_3" );
	playBtn->setGeometry( 230, 39, 36, 24 );
	connect( playBtn, SIGNAL(pressed()), SLOT(playSongPressed()) );
	connect( playBtn, SIGNAL(released()), SLOT(playSongReleased()) );
	playBtn->setAutoRepeat( false );
	playBtn->setAutoResize( false );

	ffBtn = new PicButton( this, "PicButton_4" );
	ffBtn->setGeometry( 275, 39, 36, 24 );
	connect( ffBtn, SIGNAL(pressed()), SLOT(forwardSongPressed()) );
	connect( ffBtn, SIGNAL(released()), SLOT(forwardSongReleased()) );
	ffBtn->setAutoRepeat( false );
	ffBtn->setAutoResize( false );

	nextBtn = new PicButton( this, "PicButton_5" );
	nextBtn->setGeometry( 320, 39, 36, 24 );
	connect( nextBtn, SIGNAL(pressed()), SLOT(nextSongPressed()) );
	connect( nextBtn, SIGNAL(released()), SLOT(nextSongReleased()) );
	nextBtn->setAutoRepeat( true );
	nextBtn->setAutoResize( false );

	songLCD->display(1);
	QToolTip::add(songLCD,i18n("Song number"));
	
	// Init pixmap pointers.
	
	prevPic = new QPixmap((const char**)prev_xpm);
	stopPic = new QPixmap((const char**)stop_xpm);
	playPic = new QPixmap((const char**)play_xpm);
	ffPic = new QPixmap((const char**)ff_xpm);
	nextPic = new QPixmap((const char**)next_xpm);

	stop_pPic = new QPixmap((const char**)stop_p_xpm);
	pause_pPic = new QPixmap((const char**)pause_p_xpm);
	ff_pPic = new QPixmap((const char**)ff_p_xpm);
	
	prev_lPic = new QPixmap((const char**)prev_l_xpm);
	stop_lPic = new QPixmap((const char**)stop_l_xpm);
	play_lPic = new QPixmap((const char**)play_l_xpm);
	pause_lPic = new QPixmap((const char**)pause_l_xpm);
	ff_lPic = new QPixmap((const char**)ff_l_xpm);
	next_lPic = new QPixmap((const char**)next_l_xpm);
	
	prev_l_pPic = new QPixmap((const char**)prev_l_p_xpm);
	stop_l_pPic = new QPixmap((const char**)stop_l_p_xpm);
	play_l_pPic = new QPixmap((const char**)play_l_p_xpm);
	next_l_pPic = new QPixmap((const char**)next_l_p_xpm);
	
	buttonsOff();
}

MainDialog::~MainDialog()
{
}

void MainDialog::invokeHelp()
{
	if (!thisapp) {
		return;
	};

	thisapp->invokeHTMLHelp("ksidplayer/ksidplayer.html", "");
}   

void MainDialog::connectFileDialog()
{
	connect(myFileDlg,SIGNAL(fileHighlighted(const char*)),this,SLOT(playFile(const char*)));
}

void MainDialog::enableWaveViewDlg(bool val)
{
	menu->setItemEnabled(waveViewID,val);
}

void MainDialog::done(int r)
{
	extern void stopPlaying();
	stopPlaying();
	extern void writeConfigFile();
	writeConfigFile();
//	{
//		QMessageBox error;
//		error.setIcon(QMessageBox::Warning);
//		error.setText(i18n("Could not save configuration file."));
//		error.adjustSize();
//		error.show();
//	}
	QDialog::done(r);
}

void MainDialog::adjustCommandButtons()
{
	if (!isReadyToPlay)
	{
		prevBtn->setPixmap(*prevPic);
		stopBtn->setPixmap(*stopPic);
		playBtn->setPixmap(*playPic);
		ffBtn->setPixmap(*ffPic);
		nextBtn->setPixmap(*nextPic);
		return;
	}
	else
	{
		if ( mySidTune )
		{
			mySidTune.getInfo(mySidTuneInfo);
		}
		else
		{
			mySidTuneInfo.currentSong = 1;
			mySidTuneInfo.songs = 1;
		}
		showSidTuneInfo();
	}
}

void MainDialog::buttonsOff()
{
	prevBtn->setPixmap(*prevPic);
	stopBtn->setPixmap(*stopPic);
	playBtn->setPixmap(*playPic);
	ffBtn->setPixmap(*ffPic);
	nextBtn->setPixmap(*nextPic);
}

void MainDialog::buttonsForceInitialState()
{
	// Make them look like when playing.
	setPrevBtnState();
	stopBtn->setPixmap(*stop_lPic);
	playBtn->setPixmap(*pause_lPic);
	ffBtn->setPixmap(*ff_lPic);
	setNextBtnState();
}

void MainDialog::showSidTuneInfo()
{
	if (mySidTune)
    {
		mySidTune.getInfo(mySidTuneInfo);
		
		QString tmp;
		tmp = i18n("Name      : ");
		tmp += mySidTuneInfo.infoString[0];
                tmp += "\n";
		tmp += i18n("Author    : ");
		tmp += mySidTuneInfo.infoString[1];
                tmp += "\n";
		tmp += i18n("Copyright : ");
		tmp += mySidTuneInfo.infoString[2];
                tmp += "\n";
		QString tmp2;
		tmp2.sprintf(i18n("Addresses : $%04x, $%04x, $%04x"),
				 mySidTuneInfo.loadAddr,
				 mySidTuneInfo.initAddr,
				 mySidTuneInfo.playAddr);
		tmp += tmp2;
		tmp +="\n";
		tmp2.sprintf(i18n("Songs     : %d (Startsong: %d)"),
					 mySidTuneInfo.songs,
					 mySidTuneInfo.startSong);
		tmp += tmp2;
		tmp += "\n";
		tmp2.sprintf(i18n("Song speed: %s"),mySidTuneInfo.speedString);
		tmp += tmp2;
		tmp += "\n";
		tmp2.sprintf(i18n("Format    : %s"),mySidTuneInfo.formatString);
		tmp += tmp2;
		infoField->setText(tmp);
			
		songLCD->display(mySidTuneInfo.currentSong);
	}
	else
	{
		// error
	}
}

void MainDialog::clearSidTuneInfo()
{
	QString tmp;
	tmp  = i18n("Name      :");
	tmp += " \n";
	tmp += i18n("Author    :");
	tmp += " \n";
	tmp += i18n("Copyright :");
	tmp += " \n";
	tmp += i18n("Addresses :");
	tmp += " \n";
	tmp += i18n("Songs     :");
	tmp += " \n";
	tmp += i18n("Song speed:");
	tmp += " \n";
	tmp += i18n("Format    :");
	tmp += " \n";
	infoField->setText(tmp);
}

void MainDialog::drawTime(char* timeString)
{
	timeLCD->display(timeString);
}

void MainDialog::playFile(const char* fileName)
{
	QFile testFile(fileName);
	if (testFile.exists())
	{
		extern void loadSidTune(const char* fileName);
		loadSidTune(fileName);
		loadStilData(fileName);
	}
}

void MainDialog::quit()
{
	extern void stopPlaying();
	stopPlaying();
	extern writeConfigFile();
	writeConfigFile();
//	{
//		QMessageBox error;
//		error.setIcon(QMessageBox::Warning);
//		error.setText(i18n("Could not save configuration file."));
//		error.adjustSize();
//		error.show();
//	}
	qApp->quit();
}

void MainDialog::open()
{
    myFileDlg->show();
}

void MainDialog::saveAs()
{
	if (mySidTune)
    {
		if ( !mySidTune.savePSIDfile(QFileDialog::getSaveFileName(),true) )
		{			
			QMessageBox error;
			error.setIcon(QMessageBox::Critical);
			error.setText(i18n("Could not save file."));
			error.adjustSize();
			error.show();
		}
	}
}

void MainDialog::about()
{
	QString verCat = "KSidplayer 0.52\n\n";
        verCat += i18n("Written by Maik Rder");
	verCat += "\n\n";
	verCat += i18n("based on:");
	verCat += "\n";
        verCat += "SIDPLAY/X11 v1.1.7";
	verCat += "\n\n";
	verCat += i18n("Music player and SID chip emulator ");
	// verCat += myEmuEngine.getVersionString();
	verCat += "\n";
	verCat += i18n("Written by Michael Schwendt");
	verCat += "\n\n";
	verCat += i18n("Listening mileage: ");
	extern udword usage;
	udword mileage = usage+myEmuEngine.getSecondsTotal();
	int days = mileage/(3600L*24);
	mileage -= days*(3600L*24);
	int hours = mileage/3600L;
	mileage -= hours*3600L;
	int minutes = mileage/60;
	mileage -= minutes*60;
	QString timeCat;
	timeCat.sprintf(i18n("%d days, %d hours, %d minutes"),days,hours,minutes);
	verCat += timeCat;
	QMessageBox::about(this,i18n("About SIDPLAY"),verCat);
}

void MainDialog::aboutQt()
{
	QMessageBox::aboutQt(this);
}

void MainDialog::openAudioDialog()
{
	myAudioDlg->presetButtons();
	myAudioDlg->show();
}

void MainDialog::openEmulatorDialog()
{
	myEmuDlg->presetButtons();
	myEmuDlg->show();
}

void MainDialog::openFilterDialog()
{
	myFilterDlg->presetButtons();
	myFilterDlg->show();
}

void MainDialog::openMixerDialog()
{
	myMixerDlg->presetButtons();
	myMixerDlg->adjustMixerMode();
	myMixerDlg->show();
}

void MainDialog::openWaveViewDialog()
{
	if ( !myWaveViewDlg->isShown() )
		myWaveViewDlg->show();
}

// --------------------------------------------------------------------------

void MainDialog::prevSongPressed()
{
	if (mySidTune)
    {
		int playbackStateOld = playbackState;
		playbackState = IS_INTERRUPTED;
		
		mySidTune.getInfo(mySidTuneInfo);
		if (mySidTuneInfo.currentSong != 1)
		{
			prevBtn->setPixmap(*prev_l_pPic);
	
			sidEmuInitializeSong(myEmuEngine,mySidTune,mySidTuneInfo.currentSong-1);
			extern void initTimeDisplay();
			initTimeDisplay();
			mySidTune.getInfo(mySidTuneInfo);
			if ( !mySidTune )
			{
				playbackStateOld = (playbackState = IS_STOPPED);
			}
			showSidTuneInfo();
			showStilInfo();
		}
		playbackState = playbackStateOld;
	}
	adjustCommandButtons();
	setNextBtnState();
}

void MainDialog::prevSongReleased()
{
	setPrevBtnState();
}

void MainDialog::setPrevBtnState()
{
	// PREV possible ?
	if (mySidTuneInfo.currentSong == 1)
	{
		prevBtn->setPixmap(*prevPic);
	}
	else
	{
		prevBtn->setPixmap(*prev_lPic);
	}
}

void MainDialog::nextSongPressed()
{
	if (mySidTune)
    {
		int playbackStateOld = playbackState;
		playbackState = IS_INTERRUPTED;

		mySidTune.getInfo(mySidTuneInfo);
		if (mySidTuneInfo.currentSong != mySidTuneInfo.songs)
		{
			nextBtn->setPixmap(*next_l_pPic);
		
			sidEmuInitializeSong(myEmuEngine,mySidTune,mySidTuneInfo.currentSong+1);
			extern void initTimeDisplay();
			initTimeDisplay();
			mySidTune.getInfo(mySidTuneInfo);
			if ( !mySidTune )
			{
				playbackStateOld = (playbackState = IS_STOPPED);
			}
			showSidTuneInfo();
			showStilInfo();
		}
		playbackState = playbackStateOld;
	}
	adjustCommandButtons();
	setPrevBtnState();
}

void MainDialog::nextSongReleased()
{
	setNextBtnState();
}

void MainDialog::setNextBtnState()
{
	// NEXT possible ?
	if (mySidTuneInfo.currentSong == mySidTuneInfo.songs)
	{
		nextBtn->setPixmap(*nextPic);
	}
	else
	{
		nextBtn->setPixmap(*next_lPic);
	}
}

void MainDialog::stopSongPressed()
{
	if (isReadyToPlay && !(playbackState & IS_STOPPED))
	{
		stopBtn->setPixmap(*stop_l_pPic);
		playBtn->setPixmap(*play_lPic);
		ffBtn->setPixmap(*ffPic);
		extern void stopPlaying();
		stopPlaying();
	}
}

void MainDialog::stopSongReleased()
{
	stopBtn->setPixmap(*stopPic);
}

void MainDialog::playSongPressed()
{
	if (playbackState & IS_STOPPED)
	{
		stopBtn->setPixmap(*stop_lPic);
		playBtn->setPixmap(*play_l_pPic);
		//
		extern void startPlaying();
		startPlaying();
	}
	else if (playbackState & IS_PLAYING)
	{
		playBtn->setPixmap(*pause_pPic);
		//
		extern pausePlaying();
		pausePlaying();
	}
	else if (playbackState & IS_PAUSED)
	{
		playBtn->setPixmap(*play_l_pPic);
		//
		extern resumePlaying();
		resumePlaying();
	}
}

void MainDialog::playSongReleased()
{
	if (playbackState & IS_PLAYING)
	{
		playBtn->setPixmap(*pause_lPic);
		ffBtn->setPixmap(*ff_lPic);
	}
	else if (playbackState & IS_PAUSED)
	{
		playBtn->setPixmap(*play_lPic);
		ffBtn->setPixmap(*ffPic);
	}
}

void MainDialog::forwardSongPressed()
{
	extern bool sidEmuFastForwardReplay(int);
	if (playbackState & IS_FORWARDING)
	{
		ffBtn->setPixmap(*ff_lPic);
		sidEmuFastForwardReplay(100);
		playbackState = IS_PLAYING;
	}
	else if (playbackState & IS_PLAYING)
	{
		ffBtn->setPixmap(*ff_pPic);
		sidEmuFastForwardReplay(10);
		playbackState |= IS_FORWARDING;
	}
}

void MainDialog::forwardSongReleased()
{
	if (playbackState & IS_FORWARDING)
	{
		ffBtn->setPixmap(*ff_pPic);
	}
	else if (playbackState & IS_PLAYING)
	{
		ffBtn->setPixmap(*ff_lPic);
	}
}

// STIL stuff.

static QString* hvscFileName = 0;
static QString* stilEntryName = 0;

void MainDialog::loadStilData(const char* fileName)
{
	if ( !extra->isItemChecked(stilID) )
		return;
	
	extern QDir* hvscPath;
	if (hvscPath != 0)
	{
		if (stilEntryName != 0)
			delete stilEntryName;
		if (hvscFileName != 0)
			delete hvscFileName;
		stilEntryName = hvscFileName = 0;
		QString fileNameStr = fileName;
		// Filename is somewhere in HVSC directory?
		if (fileNameStr.find(hvscPath->absPath()) == 0)
		{
			// Get enough room for fileName (+ " #<songNum>").
			uint minLen = fileNameStr.length()-hvscPath->absPath().length();
			hvscFileName = new QString(minLen);
			hvscFileName->insert(0,fileName+hvscPath->absPath().length());
			stilEntryName = new QString(10+minLen);
		}
		showStilInfo();  // either show or hide
	}
}

void MainDialog::showStilInfo()
{
	if ( !extra->isItemChecked(stilID) )
		return;
	
	extern QDir* hvscPath;
	if (hvscPath!=0 && hvscFileName!=0 && stilEntryName!=0)
	{
		extern QDict<char>* stilDict;
		// Create STIL-like path + " #<songNum>" string.
		QString tmp(10);
		tmp.sprintf(" #%d",mySidTuneInfo.currentSong);
		stilEntryName->truncate(0);
		stilEntryName->insert(0,*hvscFileName);
		stilEntryName->append(tmp);
		// First look up normal sidtune path in dictionary.
		const char* stilEntry = stilDict->find(*hvscFileName);
		if (stilEntry != 0)
		{
			myStilDlg->setText(stilEntry);
			if ( !myStilDlg->isVisible() )
				myStilDlg->show();
		}
		// Try looking up path + " #<songNum>".
		else if ((stilEntry = stilDict->find(*stilEntryName)) != 0)
		{
			myStilDlg->setText(stilEntry);
			if ( !myStilDlg->isVisible() )
				myStilDlg->show();
		}
		else
		{
			myStilDlg->hide();
		}
	}
	else
	{
		myStilDlg->hide();
	}
}

void MainDialog::toggleStilDialog()
{
	if ( !extra->isItemChecked(stilID) )
	{
		extern bool handleStil();
		extra->setItemChecked(stilID,handleStil());
	}
	else
	{
		extra->setItemChecked(stilID,false);
		myStilDlg->hide();
	}
}

bool MainDialog::isStilInfoEnabled()
{
	return extra->isItemChecked(stilID);
}

void MainDialog::setStilInfoEnabled(bool val)
{
	extra->setItemChecked(stilID,val);
}
