//
// /home/ms/sidplay/qtsidplay/RCS/rcfile.cpp,v
//
#include "rcfile.h"

void readMergedPanPosLeft(voiceVol panLevels[4], udword allPanPosLeft)
{
	panLevels[0].l = (allPanPosLeft>>24)&255;
	panLevels[1].l = (allPanPosLeft>>16)&255;
	panLevels[2].l = (allPanPosLeft>>8)&255;
	panLevels[3].l = allPanPosLeft&255;
}

void readMergedPanPosRight(voiceVol panLevels[4], udword allPanPosRight)
{
	panLevels[0].r = (allPanPosRight>>24)&255;
	panLevels[1].r = (allPanPosRight>>16)&255;
	panLevels[2].r = (allPanPosRight>>8)&255;
	panLevels[3].r = allPanPosRight&255;
}

void readConfigFile() {

	cout << "Reading Default Settings";
	read_Default_Settings();
	cout << " Done.\n";

	cout << "Reading Audio Settings ...";
	read_Audio_Settings();
	cout << " Done.\n";

	cout << "Reading Emulator Settings ...";
	read_Emulator_Settings();
	cout << " Done.\n";

	cout << "Reading Mixer Settings ...";
	read_Mixer_Settings();
	cout << " Done.\n";

	cout << "All Settings read. Ready.\n";
}

void read_Default_Settings()
{
	// Goto Default Settings

	KConfig* config = kapp->getConfig();
	KConfigGroupSaver saver (config, "");

	// Listening Mileage
	// udword: toULong
	if (config->hasKey(keyword_Usage)) {
		usage = (config->readEntry (keyword_Usage)).toULong();
	};

	// Sidtunes directory.
	if (config->hasKey(keyword_Directory)) {
		QString directory = config->readEntry (keyword_Directory);
		myFileDlg->setDir(directory);
	};

	// Name Filter
	if (config->hasKey(keyword_NameFilter)) {
		QString name_filter = config->readEntry (keyword_NameFilter);
		QFileDialog* myBakFileDlg = myFileDlg;
		myFileDlg = new QFileDialog(myBakFileDlg->dirPath(),name_filter,0,0,false);
		myFileDlg->setGeometry(myBakFileDlg->frameGeometry());
		myFileDlg->setCaption("Sidtune Selection");
		myFileDlg->setIcon(*myMainIcon);
		delete myBakFileDlg;
		myMainDlg->connectFileDialog();
	};

	//HVSC Root
	if (config->hasKey(keyword_HVSCroot)) {
		QString hvsc = config->readEntry (keyword_HVSCroot);
		hvscPath = new QDir(hvsc);
	};
}

void read_Audio_Settings()
{

	// Goto Audio Settings
	KConfig* config = kapp->getConfig();


	KConfigGroupSaver saver (config, "Audio quality settings");

	// Frequency
	//udword: toUlong
	if (config->hasKey(keyword_Frequency)) {
		myEmuConfig.frequency = (config->readEntry(keyword_Frequency)).toULong();
	};
	
	// Channels
	// atoi: toInt
	if (config->hasKey(keyword_Channels)) {
		int channels = (config->readEntry (keyword_Channels)).toInt();
		if (channels == 1) {
			myEmuConfig.channels = SIDEMU_MONO;
		}
		else {
			myEmuConfig.channels = SIDEMU_STEREO;
		}
	};	

	// Bits per Sample
	// atoi: toInt
	if ( config->hasKey(keyword_BitsPerSample)) {
		int bitspersample = (config->readEntry(keyword_BitsPerSample)).toInt();
		if (bitspersample == 8) {
			myEmuConfig.bitsPerSample = SIDEMU_8BIT;
		}
		else {
			myEmuConfig.bitsPerSample = SIDEMU_16BIT;
		}
	};

	// Fragments
	// udword: toULong
	if (config->hasKey(keyword_Fragments)) {
		int frag = (config->readEntry (keyword_Fragments)).toULong();
		if (frag < 2) {
			frag=2;
		};

		myBufferConfig.fragments = frag;
	};

	// Fragment Size
	// udword: toUlong
	if (config->hasKey(keyword_FragmentSize)) {
		udword size = (config->readEntry (keyword_FragmentSize)).toULong();
		int fragExp = 0;
		while (size > 1) {
			size >>=1;
			fragExp++;
		};
		if (fragExp < 7) {
			fragExp = 7;
		};
		myBufferConfig.fragSizeExp = fragExp;
	};	
			
	// Buffer Size
	// int: toInt
	if (config->hasKey(keyword_BufferSize)) {
		int bufSize = (config->readEntry (keyword_BufferSize)).toInt();
		if (bufSize < 256) {
			bufSize = 256;
		};
		myBufferConfig.bufferSize = bufSize;
	};
}


void read_Emulator_Settings()
{

	// Goto Emulator Settings
	KConfig* config = kapp->getConfig();
	KConfigGroupSaver saver (config, "Emulator settings");

	// ClockSpeed
	if (config->hasKey(keyword_ClockSpeed)) {
		QString clock = config->readEntry (keyword_ClockSpeed);
		if (clock.contains(keyword_PAL) == 1) {
			myEmuConfig.clockSpeed = SIDTUNE_CLOCK_PAL;
		}
		else {
			myEmuConfig.clockSpeed = SIDTUNE_CLOCK_NTSC;
		};
	};

	// Force Song Speed
	if (config->hasKey(keyword_ForceSongSpeed)) {
		QString force = config->readEntry (keyword_ForceSongSpeed);
		if (force.contains(keyword_Yes)==1) {
			myEmuConfig.forceSongSpeed = true;
		}
		else {
			myEmuConfig.forceSongSpeed = false;
		};
	};

	// Memory Mode
	if (config->hasKey(keyword_MemoryMode)) {
		QString memory_mode = config->readEntry (keyword_MemoryMode);
		if (memory_mode.contains(keyword_FullBankSwitching)) {
			myEmuConfig.memoryMode = MPU_BANK_SWITCHING;
		}
		else if (memory_mode.contains(keyword_TransparentROM)) {
			myEmuConfig.memoryMode = MPU_TRANSPARENT_ROM;
		}
		else {
			myEmuConfig.memoryMode = MPU_PLAYSID_ENVIRONMENT;
		};
	};

	//MOS8580
	if (config->hasKey(keyword_MOS8580)) {
		QString mos = config->readEntry (keyword_MOS8580);
		if (mos.contains(keyword_Yes)==1) {
			myEmuConfig.mos8580 = true;
		}
		else {
			myEmuConfig.mos8580 = false;
		};
	};

	//Measured Master Volume
	if (config->hasKey(keyword_MeasuredMasterVolume)) {
		QString mmv = config->readEntry (keyword_MeasuredMasterVolume);
		if (mmv.contains(keyword_Yes)==1) {
			myEmuConfig.measuredVolume = true;
		}
		else {
			myEmuConfig.measuredVolume = false;
		};
	};
	
	// Use Filter
	if (config->hasKey(keyword_UseFilter)) {
		QString usefilter = config->readEntry (keyword_UseFilter);
		if (usefilter.contains(keyword_Yes)==1) {
			myEmuConfig.emulateFilter = true;
		}
		else {
			myEmuConfig.emulateFilter = false;
		};
	};
	
	// FilterFs
	// atof: toFloat
	if (config->hasKey(keyword_FilterFs)) {
		myEmuConfig.filterFs =(config->readEntry(keyword_FilterFs)).toFloat();
	};
	
	// FilterFm
	// atof: toFloat
	if (config->hasKey(keyword_FilterFm)) {
		myEmuConfig.filterFm =(config->readEntry(keyword_FilterFm)).toFloat();
	};

	//FilterFt
	// atof: toFloat
	if (config->hasKey(keyword_FilterFt)) {
		myEmuConfig.filterFt =(config->readEntry(keyword_FilterFt)).toFloat();
	};
}
	
void read_Mixer_Settings()
{

	// Goto Mixer Settings
	KConfig* config = kapp->getConfig();
	KConfigGroupSaver saver (config, "Mixer settings");

	// Mixer settings.
	if (config->hasKey(keyword_Mixer)) {
		QString mixer = config->readEntry (keyword_Mixer);
		if (mixer.contains(keyword_HQ)) {
			myEmuConfig.volumeControl = SIDEMU_VOLCONTROL;
		}
		else if (mixer.contains(keyword_FP)) {
			myEmuConfig.volumeControl = SIDEMU_FULLPANNING;
		}
		else if (mixer.contains(keyword_StereoSurround)) {
			myEmuConfig.volumeControl = SIDEMU_STEREOSURROUND;
		}
		else {
			myEmuConfig.volumeControl = SIDEMU_NONE;
		};
	};
	
	// Auto Panning
	if (config->hasKey(keyword_AutoPanning)) {
		QString auto_panning = config->readEntry (keyword_AutoPanning);
		if (auto_panning.contains(keyword_Centered)) {
			myEmuConfig.autoPanning = SIDEMU_CENTEREDAUTOPANNING;
		}
		else {
			myEmuConfig.autoPanning = SIDEMU_NONE;
		};
	};

	// Voice 1 Vol
	if (config->hasKey(keyword_Voice1Vol)) {
		QString v1vol = config->readEntry(keyword_Voice1Vol);
		voiceMasterVol[0] = atoi(v1vol);
	};

	// Voice 2 Vol
	if (config->hasKey(keyword_Voice2Vol)) {
		QString v2vol = config->readEntry(keyword_Voice2Vol);
		voiceMasterVol[1] = atoi(v2vol);
	};

	// Voice 3 Vol
	if (config->hasKey(keyword_Voice3Vol)) {
		QString v3vol = config->readEntry(keyword_Voice3Vol);
		voiceMasterVol[2] = atoi(v3vol);
	};

	// Voice 4 Vol
	if (config->hasKey(keyword_Voice4Vol)) {
		QString v4vol = config->readEntry(keyword_Voice4Vol);
		voiceMasterVol[3] = atoi(v4vol);
	};

	// Pan Pos Left HQ
	if (config->hasKey(keyword_PanPosLeftHQ)) {
		QString pplhq= config->readEntry (keyword_PanPosLeftHQ);
		readMergedPanPosLeft(voiceHQvol,atol(pplhq));
	};

	// Pan Pos Right HQ
	if (config->hasKey(keyword_PanPosRightHQ)) {
		QString pprhq = config->readEntry (keyword_PanPosRightHQ);
		readMergedPanPosRight(voiceHQvol,atol(pprhq));
	};

	// Pan Pos Left FP
	if (config->hasKey(keyword_PanPosLeftFP)) {
		QString pplfp = config->readEntry (keyword_PanPosLeftFP);
		readMergedPanPosLeft(voiceFPvol,atol(pplfp));
	};

	//Pan Pos Right Fp
	if (config->hasKey(keyword_PanPosRightFP)) {
		QString pprfp = config->readEntry (keyword_PanPosRightFP);
		readMergedPanPosRight(voiceFPvol,atol(pprfp));
	};
}

// ------------------------------------------------------------------- Output

void writeConfigFile() {

	// Write Default Settings
	cout << "Writing Default Settings";
	write_Default_Settings();
	cout << " Done.\n";

	// Write Audio Settings
	cout << "Writing Audio Settings ...";
	write_Audio_Settings();
	cout << " Done.\n";
	
	// Write Emulator Settings
	cout << "Writing Emulator Settings ...";
	write_Emulator_Settings();
	cout << " Done.\n";

	// Write Mixer Settings
	cout << "Writing Mixer Settings ...";
	write_Mixer_Settings();
	cout << " Done.\n";

	cout << "All Settings written. Ready.\n";

}


void write_Default_Settings ()
{
	
        KConfig* config = kapp->getConfig();
        KConfigGroupSaver saver (config, "");
	
	// Sidtunes directory.
	config->writeEntry ( keyword_Directory, myFileDlg->dirPath() );
	
	config->writeEntry ( keyword_NameFilter, myFileDlg->dir()->nameFilter() );

	if (hvscPath != 0) {
		config->writeEntry (keyword_HVSCroot, hvscPath->path());
	};
	
	// Listening mileage.
	config->writeEntry ( keyword_Usage, usage+myEmuEngine.getSecondsTotal());
}

void write_Audio_Settings ()
{
        KConfig* config = kapp->getConfig();
        KConfigGroupSaver saver (config, "Audio quality settings");

	config->writeEntry( keyword_Frequency, (ulong)myEmuConfig.frequency);
	config->writeEntry( keyword_Channels, (int)myEmuConfig.channels);
	config->writeEntry( keyword_BitsPerSample, (int)myEmuConfig.bitsPerSample);

	extern bool expertMode;
	if (expertMode)
	{
		// Don't destroy user's sane settings.
		config->writeEntry( keyword_Fragments, bakBufferConfig.fragments);
		config->writeEntry( keyword_FragmentSize, (1L<<bakBufferConfig.fragSizeExp));
		config->writeEntry( keyword_BufferSize, bakBufferConfig.bufferSize);
	}
	else
	{
		config->writeEntry( keyword_Fragments, myBufferConfig.fragments);
		config->writeEntry( keyword_FragmentSize, (1L<<myBufferConfig.fragSizeExp) );
		config->writeEntry( keyword_BufferSize, myBufferConfig.bufferSize);
	}
}

void write_Emulator_Settings ()
{
	
        KConfig* config = kapp->getConfig();
        KConfigGroupSaver saver (config, "Emulator settings");

	if (myEmuConfig.clockSpeed == SIDTUNE_CLOCK_PAL) {
		config->writeEntry (keyword_ClockSpeed, keyword_PAL);
	}
	else if (myEmuConfig.clockSpeed == SIDTUNE_CLOCK_NTSC) {
		config->writeEntry (keyword_ClockSpeed, keyword_NTSC);
	};

	if (myEmuConfig.forceSongSpeed==true) {
		config->writeEntry ( keyword_ForceSongSpeed, keyword_Yes);
	}
	else {
		config->writeEntry ( keyword_ForceSongSpeed, keyword_No);
	};	
	
	if (myEmuConfig.memoryMode == MPU_BANK_SWITCHING) {
		config->writeEntry (keyword_MemoryMode, keyword_FullBankSwitching);
	}
	else if (myEmuConfig.memoryMode == MPU_TRANSPARENT_ROM) {
		config->writeEntry (keyword_MemoryMode, keyword_TransparentROM);
	} 
	else if (myEmuConfig.memoryMode == MPU_PLAYSID_ENVIRONMENT) {
		config->writeEntry ( keyword_MemoryMode, keyword_PlaySID);
	};

	if ( myEmuConfig.mos8580 == true) {
		config->writeEntry(keyword_MOS8580, keyword_Yes);
	}
	else {
		config->writeEntry(keyword_MOS8580, keyword_No);
	}

	if (myEmuConfig.measuredVolume == true) {
		config->writeEntry( keyword_MeasuredMasterVolume, keyword_Yes );
	}
	else {
		config->writeEntry( keyword_MeasuredMasterVolume, keyword_No );
	};

	if ( myEmuConfig.emulateFilter == true) {
		config->writeEntry(keyword_UseFilter, keyword_Yes);
	}
	else {
		config->writeEntry(keyword_UseFilter, keyword_No);
	}; 

	config->writeEntry ( keyword_FilterFs, myEmuConfig.filterFs);
	config->writeEntry ( keyword_FilterFm, myEmuConfig.filterFm);
	config->writeEntry ( keyword_FilterFt, myEmuConfig.filterFt);
}

void write_Mixer_Settings ()
{
        KConfig* config = kapp->getConfig();
        KConfigGroupSaver saver (config, "Mixer settings");

	if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL) {
		config->writeEntry (keyword_Mixer, keyword_HQ);
	}
	else if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING) {
		config->writeEntry (keyword_Mixer, keyword_FP);
	}
	else if (myEmuConfig.volumeControl == SIDEMU_STEREOSURROUND) {
		config->writeEntry (keyword_Mixer, keyword_StereoSurround);
	}
	else {
		config->writeEntry ( keyword_Mixer, keyword_No);
	};
			
	if (myEmuConfig.autoPanning == SIDEMU_CENTEREDAUTOPANNING) {
		config->writeEntry (keyword_AutoPanning, keyword_Centered);
	}
	else {
		config->writeEntry ( keyword_AutoPanning, keyword_No);
	};

	config->writeEntry ( keyword_Voice1Vol, (int)voiceMasterVol[0] );
	config->writeEntry ( keyword_Voice2Vol, (int)voiceMasterVol[1] );
	config->writeEntry ( keyword_Voice3Vol, (int)voiceMasterVol[2] );
	config->writeEntry ( keyword_Voice4Vol, (int)voiceMasterVol[3] );

	long int pan=0;

	pan = getMergedPanPosLeft( voiceHQvol );
	config->writeEntry ( keyword_PanPosLeftHQ, pan);

	pan = getMergedPanPosRight( voiceHQvol );
	config->writeEntry ( keyword_PanPosRightHQ, pan);

	pan = getMergedPanPosLeft( voiceFPvol );
	config->writeEntry ( keyword_PanPosLeftFP, pan);

	pan = getMergedPanPosRight( voiceFPvol );
	config->writeEntry ( keyword_PanPosRightFP, pan);
}

long int getMergedPanPosLeft( voiceVol panLevels[4] )
{
	long int allPanPosLeft;
	allPanPosLeft = (panLevels[0].l<<24)+(panLevels[1].l<<16)+
		(panLevels[2].l<<8)+(panLevels[3].l);
	return allPanPosLeft;
}

long int getMergedPanPosRight( voiceVol panLevels[4])
{
	long int allPanPosRight;
	allPanPosRight = (panLevels[0].r<<24)+(panLevels[1].r<<16)+
		(panLevels[2].r<<8)+(panLevels[3].r);
	return allPanPosRight;
}
