//
// /home/ms/sidplay/qtsidplay/RCS/rcfile.cpp,v
//

#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>

#include <qdir.h>
#include <qfiledlg.h>
#include <qstring.h>

#include <kconfig.h>
#include <kapp.h>

#include "MainDialog.h"
#include "GlobalExt.h"
#include "textfile.h"

#include "xsidplay.h"
#include <sidplay/mytypes.h>
#include <sidplay/emucfg.h>

extern uword voiceMasterVol[4];

struct voiceVol { uword l, r; };  // as used in mixerwin
extern voiceVol voiceHQvol[4];
extern voiceVol voiceFPvol[4];

QDir* hvscPath;
bool stilInfoDesired = false;

// --------------------------------------------------------------------------
// CONFIGURATION FILE EVALUATION
// --------------------------------------------------------------------------

extern bufferConfig myBufferConfig;
extern bufferConfig bakBufferConfig;
extern udword usage;

static QString configPath;
static const QString configFile = ".sidplayrc";

// Keywords.
static const char keyword_Frequency[] = "Frequency";
static const char keyword_Channels[] = "Channels";
static const char keyword_BitsPerSample[] = "BitsPerSample";
static const char keyword_Fragments[] = "Fragments";
static const char keyword_FragmentSize[] = "FragmentSize";
static const char keyword_BufferSize[] = "BufferSize";

static const char keyword_ForceSongSpeed[] = "ForceSongSpeed";
static const char keyword_ClockSpeed[] = "ClockSpeed";
static const char keyword_MemoryMode[] = "MemoryMode";
static const char keyword_MOS8580[] = "MOS8580";
static const char keyword_MeasuredMasterVolume[] = "MeasuredMasterVolume";
static const char keyword_UseFilter[] = "UseFilter";
static const char keyword_FilterFs[] = "FilterFs";
static const char keyword_FilterFm[] = "FilterFm";
static const char keyword_FilterFt[] = "FilterFt";

static const char keyword_Mixer[] = "Mixer";
static const char keyword_AutoPanning[] = "AutoPanning";
static const char keyword_Voice1Vol[] = "Voice1Vol";
static const char keyword_Voice2Vol[] = "Voice2Vol";
static const char keyword_Voice3Vol[] = "Voice3Vol";
static const char keyword_Voice4Vol[] = "Voice4Vol";
static const char keyword_PanPosLeftHQ[] = "PanPosLeftHQ";
static const char keyword_PanPosRightHQ[] = "PanPosRightHQ";
static const char keyword_PanPosLeftFP[] = "PanPosLeftFP";
static const char keyword_PanPosRightFP[] = "PanPosRightFP";

static const char keyword_Yes[] = "Yes";
static const char keyword_No[] = "No";
static const char keyword_PAL[] = "PAL";
static const char keyword_NTSC[] = "NTSC";
static const char keyword_FullBankSwitching[] = "FullBankSwitching";
static const char keyword_TransparentROM[] = "TransparentROM";
static const char keyword_PlaySID[] = "PlaySID";
static const char keyword_Normal[] = "Normal";
static const char keyword_Centered[] = "Centered";
static const char keyword_StereoSurround[] = "StereoSurround";
static const char keyword_HQ[] = "HighQuality";
static const char keyword_FP[] = "FullPanning";

static const char keyword_Usage[] = "Usage";

static const char keyword_Directory[] = "Directory";
static const char keyword_NameFilter[] = "NameFilter";
static const char keyword_HVSCroot[] = "HVSCroot";

static const char keyword_MainPosX[] = "MainPosX";
static const char keyword_MainPosY[] = "MainPosY";
static const char keyword_DirPosX[] = "DirPosX";
static const char keyword_DirPosY[] = "DirPosY";
static const char keyword_DirExtX[] = "DirExtX";
static const char keyword_DirExtY[] = "DirExtY";
static const char keyword_DirOpen[] = "DirOpen";
static const char keyword_StilOpen[] = "StilOpen";

extern MainDialog* myMainDlg;
extern QFileDialog* myFileDlg;

// -------------------------------------------------------------------- Input

void readMergedPanPosLeft(voiceVol panLevels[4], udword allPanPosLeft);
void readMergedPanPosRight(voiceVol panLevels[4], udword allPanPosRight);
void readConfigFile();
void read_Default_Settings();
void read_Audio_Settings();
void read_Emulator_Settings();
void read_Mixer_Settings();

long int getMergedPanPosLeft( voiceVol panLevels[4]);
long int getMergedPanPosRight( voiceVol panLevels[4]);
void writeConfigFile();
void write_Default_Settings();
void write_Audio_Settings();
void write_Emulator_Settings();
void write_Mixer_Settings();

