/***************************************************************************
                          ksoundrecorddoc.h  -  description
                             -------------------
    begin                : Don Jan  6 20:17:39 CET 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOUNDRECORDDOC_H
#define KSOUNDRECORDDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kprocess.h>

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

// forward declaration of the Ksoundrecord classes
class KsoundrecordView;

/**	KsoundrecordDoc provides a document object for a document-view model.
  *
  * The KsoundrecordDoc class provides a document object that can be used in conjunction with the classes KsoundrecordApp and KsoundrecordView
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the KsoundrecordApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KsoundrecordView objects. Also, KsoundrecordDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class KsoundrecordDoc : public QObject
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    KsoundrecordDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KsoundrecordDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KsoundrecordView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KsoundrecordView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true){ modified=_m; };
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const QString &filename, const char *format=0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const QString &filename, const char *format=0);
    /** sets the path to the file connected with the document */
    bool savemp3(const QString &filename, const char *format=0);
    /** sets the path to the file connected with the document */
    void setAbsFilePath(const QString &filename);
    /** returns the pathname of the current document file*/
    const QString &getAbsFilePath() const;
    /** sets the filename of the document */
    void setTitle(const QString &_t);
    /** returns the title of the document */
    const QString &getTitle() const;
	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(KsoundrecordView *sender);
 	
  public:	
    /** the list of the views currently connected to the document */
    static QList<KsoundrecordView> *pViewList;	
    KProcess* cpproc;
    KProcess* cpopenproc;
    KProcess* cpmp3proc;
  private:
    /** the modified flag of the current document */
    bool modified;
    QString title;
    QString absFilePath;

};

#endif // KSOUNDRECORDDOC_H
