// Sound recorder 0.05 Aug 01 1998, GPL 2 (see COPYRIGHTS)
// 1997, 1998  B. Warmerdam

#ifndef _waveriff_h
#define _wavefiff_h

#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include "filefmt.h"

class TWave : public TFileFormat {

	private:
		struct WaveFormatCommonFields{
			u_int16_t			wFormatTag;		// Format category
			u_int16_t			wChannels;		// Number of channels
			u_int32_t			dwSamplesPerSec;	// Sampling rate
			u_int32_t			dwAvgBytesPerSec;	// For buffer estimation
			u_int16_t			wBlockAlign;		// Data block size
			u_int16_t			bitsPerSample;		// Bits per sample
		};

		struct Chunk{
			u_int8_t			chunkId[4];		// Chunk id
			u_int32_t			chunkSize;		// Chunk size
		};

		struct WaveFormat{
			u_int8_t			Signature[4];
			struct Chunk		        headerChunk;
			struct WaveFormatCommonFields	formatCommonFields;
			struct Chunk			dataChunk;
		};

		struct WaveStruct{
			struct Chunk			riffChunk;
			struct WaveFormat		wvFormat;
		};

		FILE *			fh;
		int			mode;
		struct WaveStruct	Wave;

	private:
		void	createWave(const unsigned fmt, const unsigned chnl, const unsigned bps, const unsigned smpl);

	public:
		TWave();
		~TWave();

		const bool	create(const char * filename, const unsigned fmt, const unsigned chnl,
						const unsigned bps, const unsigned smpl);
		const bool	open(const char * filename);
		const int	write(char * buffer, unsigned long len);
		const int	read(char * buffer, unsigned long len);
		void		close();
		void		getWaveInfo(unsigned & fmt, unsigned & chnl, unsigned & bps, unsigned & smpl, unsigned & bs);
		const int	sampleCount();
		void		setFileSize(const long size);
};

#endif
