/***************************************************************************
                          ksoundwidgetpro.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __KSOUNDWIDGETPRO__
#define __KSOUNDWIDGETPRO__


#include <kapp.h>  

#include <qwidget.h>
#include <qscrbar.h>
#include <kbutton.h>
#include <qbutton.h>
#include <qpushbt.h>
#include "ksoundwidget.h"
#include "kscalebar.h"

#include "timebar.h"

class KSoundWidgetPro : public QWidget
{
	Q_OBJECT
	
public:
	KSoundWidgetPro(QWidget *parent);
	KSoundWidgetPro(QWidget *parent,CSample *s);
	~KSoundWidgetPro();

	//CSample		*getSample();

	void		paint();
	KSoundWidget::Mode			getMode();
	bool		isBusy();
	void		setSample(CSample *s);
	void		setSample();
	int			loadWave(char* fn);
	int			saveWave(char* fn);
	CSample	*getSample();
	int			setZoom(int zoom,bool repaint = true);
	int			getZoom(void);
	int			setDisplayStart(int ds,bool repaint = true);
	int			getDisplayStart(void);
	int			setDisplayEnd(int de,bool repaint = true);
	int			getDisplayEnd(void);
	int			setDisplayCenter(int dc,bool repaint = true);
	int			getDisplayCenter(void);
	unsigned int	getSelectionStart();
	unsigned int	getSelectionEnd();
	void		setSelectionStart(int ss,bool repaint = true);
	void		setSelectionEnd(int se,bool repaint = true);
	int			getPointer();
	int			setPointer(int,bool repaint = true);
	void		getColors(QColor *color);
	void		setColors(QColor *color);
	int			screen2sample(int s);
	int			sample2screen(int s);

public slots:

	void		setBusy(bool busy);
	void		setMode(KSoundWidget::Mode m);
	void		changedScroll(int v);
	void		changedDispStart(int v);
	void		changedDispZoom(int v);
	void		clickedZoomIn();
	void		clickedZoomOut();

	void		gotDndURL(char *,int);
  /**  */
  void		setZoomMax();

signals:
	void		gotURL(char*,int);
	
protected:

	void		createWidgets(CSample *s = NULL);
	void		layout();
	void		paintEvent(QPaintEvent *);
	//void		resizeEvent(QResizeEvent *);


protected:

	KSoundWidget				*ksw;
	QScrollBar					*qsb;
	QPushButton					*zoom_in,*zoom_out;
	QButton							*mode_select,*mode_zoom;
	QPixmap							pm_zoom_in,pm_zoom_out;
	Timebar							*ktb;
	QArray<KScaleBar*>	ksb;
	int									nchannel;

};

#endif









