/***************************************************************************
                          kssdialogs.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kssdialogs.h"

#include <kapp.h>

namedialog::namedialog(QWidget *parent=0,const char *name=0) :
	QDialog(parent,name,true)
{
	KLocale	*locale;

	locale = new KLocale();

	line = new QLineEdit(this);

	ok = new QPushButton( this,i18n("Ok"));
	ok->setText(i18n("OK"));
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );

	cancel = new QPushButton( this,i18n("Cancel") );
	cancel->setText(i18n("Cancel"));
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	setMaximumSize(150,65);
	QDialog::resize(150,65);
	setMinimumSize(150,65);

	line->setGeometry(5,5,140,25);
	cancel->setGeometry(5,35,67,25);
	ok->setGeometry(77,35,67,25);	

	delete locale;
}

namedialog::~namedialog()
{
	delete	ok;
	delete	cancel;
	delete	line;
}

QString	namedialog::getName()
{
	return line->text();
}

kssdialog::kssdialog(QWidget *parent=0,const char *name=0,QString pf="") :
	QDialog(parent,name,true)
{
	KConfig	*config;
	
	strlist = new QStrList();

	setCaption(i18n(name));

	profile = pf;

	config = KApplication::getKApplication()->getConfig();

	config->setGroup(profile);
	config->readListEntry("Entries",*strlist);

	strlist->insert(0,"");

	list = new QComboBox(this,"Profile");
	list->insertStrList(strlist,0);


	ok = new QPushButton( this,i18n("Ok"));
	ok->setText(i18n("OK"));
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );

	cancel = new QPushButton( this,"Cancel" );
	cancel->setText(i18n("Cancel"));
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	del = new QPushButton( this,"Delete" );
	del->setText(i18n("Delete"));
	del->setEnabled(false);
	connect( del, SIGNAL(clicked()), SLOT(deleteProfile()) );

	save = new QPushButton( this,"Save");
	save->setText(i18n("Save"));
	//save->setEnabled(false);
	connect( save, SIGNAL(clicked()), SLOT(saveProfileInt()) );

	connect( this,SIGNAL(activated(const char*)),SLOT(saveProfile(const char*)) );

	connect( list,SIGNAL(activated(const char*)),SLOT(loadProfile(const char*)) );

	resize(0,0);
}

kssdialog::~kssdialog()
{
}

void	kssdialog::resize(int w,int h)
{
	if(w < 200) w = 200;
	if(h < 170) h = 170;

	setMaximumSize(w,h);
	QDialog::resize(w,h);
	setMinimumSize(w,h);

	list->setGeometry(5,5,w - 10,25);
	save->setGeometry(w - 105,35,100,25);
	del->setGeometry(w - 105,65,100,25);
	cancel->setGeometry(w - 105,h - 60,100,25);
	ok->setGeometry(w - 105,h - 30,100,25);
}

QString	kssdialog::getName(char *namename)
{
	namedialog nd(this,namename);

	nd.setCaption(namename);

	nd.show();

	if(nd.result())
	{
		return nd.getName();
	}
	else return "";
}

void	kssdialog::addEntry(QString entry)
{
	uint		t;
	KConfig	*config = KApplication::getKApplication()->getConfig();


	for(t = 0;t < strlist->count();t++)
	{
		if(strlist->at(t) == entry)
		{
		/*
			ask for overwrite

			if(overwrite)
		*/
			config->sync(); // overwrite

			return;
		}
	}

	strlist->first();
	strlist->remove();
	if(strlist->find(entry) < 0)
		strlist->insert(strlist->count(),entry);

	config->setGroup(profile);
	config->writeEntry("Entries",*strlist);
	config->sync();

	strlist->insert(0,"");

	list->clear();
	list->insertStrList(strlist,0);
}

void	kssdialog::saveProfileInt()
{
	QString		qstr = getName("New Entry");

	if(qstr != "") emit activated(qstr);
}

/*
void	kssdialog::loadProfile(const char* profilename)
{
}

void	kssdialog::saveProfile(const char* profilename)
{
	QString		group = "";

	group = profile + "/" + profilename;

	strlist->insert(0,profilename);
	config->setGroup(profile);
	config->writeEntry("Entries",*strlist);
	config->setGroup(group);
	config->sync();
}

void	kssdialog::deleteProfile()
{
}
*/

envdialog::envdialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,name)
{
	kge = new KGraphEdit(this);

	resize(300,250);

	kge->setGeometry(5,45,170,170);
}

envdialog::~envdialog()
{
	delete kge;
}

QArray<double>	envdialog::getPoints()
{
	QArray<double>	a;
	int		t,n;

	n = kge->getNPoints() + 2;
	a.resize(n * 2);

	a[0] = 0;
	a[1] = kge->getLeftPoint();
	a[n * 2 - 2] = 1;
	a[n * 2 - 1] = kge->getRightPoint();
	for(t = 0;t < n - 2;t++)
	{
		kge->getPoint(t,&a[t * 2],&a[t * 2 + 1]);
	}

	return a;
}

void	envdialog::loadProfile(const char* profilename)
{
	QString		group = "",str,strt,strt2;
	QStrList	plist;
	int		n,t;
	double		x,y;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	kge->reset();

	group = profile + "/" + profilename;

	config->setGroup(group);

	n = config->readListEntry("Points",plist) / 2;
	if(n < 2)
		return;

	str = plist.at(0);
	x = str.toDouble();
	str = plist.at(1);
	y = str.toDouble();
	kge->setLeftPoint(y);

	str = plist.at((n - 1) * 2);
	x = str.toDouble();
	str = plist.at((n - 1) * 2 + 1);
	y = str.toDouble();
	kge->setRightPoint(y);

	for(t = 1;t < n - 1;t++)
	{
		str = plist.at(t * 2);
		x = str.toDouble();
		str = plist.at(t * 2 + 1);
		y = str.toDouble();
		kge->addPoint(x,y);
	}
}

void	envdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	QStrList	plist;
	double		x,y;
	int		n,t;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	n = kge->getNPoints();

	qstr.sprintf("%f",0.0);
	plist.insert(plist.count(),qstr);
	qstr.sprintf("%f",kge->getLeftPoint());
	plist.insert(plist.count(),qstr);
	
	for(t = 0;t < n;t++)
	{
		kge->getPoint(t,&x,&y);
		qstr.sprintf("%.12f",x);
		plist.insert(plist.count(),qstr);
		qstr.sprintf("%f",y);
		plist.insert(plist.count(),qstr);
	}

	qstr.sprintf("%f",1.0);
	plist.insert(plist.count(),qstr);
	qstr.sprintf("%f",kge->getRightPoint());
	plist.insert(plist.count(),qstr);

	config->writeEntry("Points",plist);

	addEntry(profilename);
}

void	envdialog::deleteProfile()
{
}

distdialog::distdialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,name)
{
	kge = new KGraphEdit(this);
	qcb = new QCheckBox(this);
	qcb->setText(i18n("Symmetric"));

	resize(300,250);

	kge->setGeometry(5,45,170,170);
	qcb->setGeometry(5,220,170,25);
}

distdialog::~distdialog()
{
	delete kge;
	delete qcb;
}

QArray<double>	distdialog::getPoints()
{
	QArray<double>	a;
	int		t,n;

	n = kge->getNPoints() + 2;
	a.resize(n * 2);

	a[0] = 0;
	a[1] = kge->getLeftPoint();
	a[n * 2 - 2] = 1;
	a[n * 2 - 1] = kge->getRightPoint();
	for(t = 0;t < n - 2;t++)
	{
		kge->getPoint(t,&a[t * 2],&a[t * 2 + 1]);
	}

	return a;
}

int	distdialog::symmetric()
{
	return qcb->isChecked();
}

void	distdialog::loadProfile(const char* profilename)
{
	QString		group = "",str,strt,strt2;
	QStrList	plist;
	int		n,t;
	double		x,y;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	kge->reset();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Symmetric","1");
	qcb->setChecked(str[0] != '0');

	n = config->readListEntry("Points",plist) / 2;
	if(n < 2) return;

	str = plist.at(0);
	x = str.toDouble();
	str = plist.at(1);
	y = str.toDouble();
	kge->setLeftPoint(y);

	str = plist.at((n - 1) * 2);
	x = str.toDouble();
	str = plist.at((n - 1) * 2 + 1);
	y = str.toDouble();
	kge->setRightPoint(y);

	for(t = 1;t < n - 1;t++)
	{
		str = plist.at(t * 2);
		x = str.toDouble();
		str = plist.at(t * 2 + 1);
		y = str.toDouble();
		kge->addPoint(x,y);
	}
}

void	distdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	QStrList	plist;
	double		x,y;
	int		n,t;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	config->writeEntry("Symmetric",(qcb->isChecked()?"1":"0"));

	n = kge->getNPoints();

	qstr.sprintf("%f",0.0);
	plist.insert(plist.count(),qstr);
	qstr.sprintf("%f",kge->getLeftPoint());
	plist.insert(plist.count(),qstr);
	
	for(t = 0;t < n;t++)
	{
		kge->getPoint(t,&x,&y);
		qstr.sprintf("%.12f",x);
		plist.insert(plist.count(),qstr);
		qstr.sprintf("%f",y);
		plist.insert(plist.count(),qstr);
	}

	qstr.sprintf("%f",1.0);
	plist.insert(plist.count(),qstr);
	qstr.sprintf("%f",kge->getRightPoint());
	plist.insert(plist.count(),qstr);

	config->writeEntry("Points",plist);

	addEntry(profilename);
}

void	distdialog::deleteProfile()
{
}

dphpdialog::dphpdialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,name)
{
	dblv = new QDoubleValidator(0.0,1.0,5,this);
	dblv->setRange(0.0,1.0,5);

	rlabel = new QLabel(this);
	rlabel->setText("R (Ohm):");

	rline = new QLineEdit(this);
	rline->setValidator(dblv);
	rline->setText("0.05");

	clabel = new QLabel(this);
	clabel->setText("C (Farat):");

	cline = new QLineEdit(this);
	cline->setValidator(dblv);
	cline->setText("0.05");

	resize(300,150);

	rlabel->setGeometry(5,45,95,25);
	rline->setGeometry(105,45,75,25);
	clabel->setGeometry(5,75,95,25);
	cline->setGeometry(105,75,75,25);

	c = 0.05;
	r = 0.05;
}

dphpdialog::~dphpdialog()
{
	delete	rline;
	delete	cline;
	delete	rlabel;
	delete	clabel;
	delete	dblv;
}

double	dphpdialog::getR()
{
	QString		s;
	float		f;

	s = rline->text();
	sscanf(s,"%f",&f);

	return (r = f);
}

double	dphpdialog::getC()
{
	QString		s;
	float		f;

	s = cline->text();
	sscanf(s,"%f",&f);

	return (c = f);
}

void	dphpdialog::loadProfile(const char* profilename)
{
	QString		group = "",str,strt,strt2;
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Resistance","0.01");
	r = str.toDouble();

	str = config->readEntry("Capacity","0.01");
	c = str.toDouble();

	str.sprintf("%f",r);
	rline->setText(str);

	str.sprintf("%f",c);
	cline->setText(str);
}

void	dphpdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = cline->text();
	c = qstr.toDouble();
	qstr = rline->text();
	r = qstr.toDouble();
	qstr.sprintf("%f",r);
	config->writeEntry("Resistance",qstr);
	qstr.sprintf("%f",c);
	config->writeEntry("Capacity",qstr);

	addEntry(profilename);
}

void	dphpdialog::deleteProfile()
{
}

blurdialog::blurdialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,name)
{
	sizelabel = new QLabel(this);
	sizelabel->setText("Size:");

	sizeline = new QLineEdit(this);
	sizeline->setText("5");

	resize(300,150);

	sizelabel->setGeometry(5,45,95,25);
	sizeline->setGeometry(105,45,75,25);

	size = 5;
}

blurdialog::~blurdialog()
{
}

double	blurdialog::getSize()
{
	QString		s;
	float		f;

	s = sizeline->text();
	sscanf(s,"%f",&f);

	return (size = f);
}

void	blurdialog::loadProfile(const char* profilename)
{
	QString		group = "",str,strt,strt2;
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Size","51");
	size = str.toDouble();

	str.sprintf("%f",size);
	sizeline->setText(str);
}

void	blurdialog::saveProfile(const char *profilename)
{
	QString	group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = sizeline->text();
	size = qstr.toDouble();
	qstr.sprintf("%f",size);
	config->writeEntry("Size",qstr);

	addEntry(profilename);
}

void	blurdialog::deleteProfile()
{
}

voldialog::voldialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,"Volume")
{
	dblv = new QDoubleValidator(0.0,1.0,5,this);
	dblv->setRange(0.0,1.0,5);

	vollabel = new QLabel(this);
	vollabel->setText(i18n("Volume (*):"));

	volline = new QLineEdit(this);
	volline->setValidator(dblv);
	volline->setText("0.7");

	resize(300,150);

	vollabel->setGeometry(5,45,95,25);
	volline->setGeometry(105,45,75,25);

	vol = 0.5;
}

voldialog::~voldialog()
{
	delete	volline;
	delete	vollabel;
	delete	dblv;
}

double	voldialog::getVol()
{
	QString		s;
	float		f;

	s = volline->text();
	sscanf(s,"%f",&f);

	return (vol = f);
}

void	voldialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Volume","0.7");
	vol = str.toDouble();

	str.sprintf("%f",vol);
	volline->setText(str);
}

void	voldialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = volline->text();
	vol = qstr.toDouble();
	qstr.sprintf("%f",vol);
	config->writeEntry("Volume",qstr);

	addEntry(profilename);
}

void	voldialog::deleteProfile()
{
}

/************************/

multiplierdialog::multiplierdialog(QString title,double defaultvalue = 1,QWidget *parent,const char *name) :
	kssdialog(parent,name,title)
{
	m_multiplier = defaultvalue;
	
	m_dblv = new QDoubleValidator(0.0,1.0,5,this);
	m_dblv->setRange(0.0,1.0,5);

	m_multlabel = new QLabel(this);
	m_multlabel->setText((QString)i18n("Multiplier") + " (*):");

	m_multline = new QLineEdit(this);
	m_multline->setValidator(m_dblv);
	m_multline->setText(QString().setNum(m_multiplier));

	resize(300,150);

	m_multlabel->setGeometry(5,45,95,25);
	m_multline->setGeometry(105,45,75,25);

}

multiplierdialog::~multiplierdialog()
{
	delete	m_dblv;
}

double	multiplierdialog::getMultiplier()
{
	QString		s;
	float		f;

	s = m_multline->text();
	sscanf(s,"%f",&f);

	return (m_multiplier = f);
}

void	multiplierdialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Multiplier","1");
	m_multiplier = str.toDouble();

	str.sprintf("%f",m_multiplier);
	m_multline->setText(str);
}

void	multiplierdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = m_multline->text();
	m_multiplier = qstr.toDouble();
	qstr.sprintf("%f",m_multiplier);
	config->writeEntry("Multiplier",qstr);

	addEntry(profilename);
}

void	multiplierdialog::deleteProfile()
{
}

/************************/

timedialog::timedialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,"Time")
{
	dblv = new QDoubleValidator(0.0,1.0,5,this);
	dblv->setRange(0.0,1.0,5);

	seclabel = new QLabel(this);
	seclabel->setText(i18n("Time (sec):"));

	secline = new QLineEdit(this);
	secline->setValidator(dblv);
	secline->setText("1.0");

	resize(300,150);

	seclabel->setGeometry(5,45,95,25);
	secline->setGeometry(105,45,75,25);

	sec = 1.0;
}

timedialog::~timedialog()
{
	delete	secline;
	delete	seclabel;
	delete	dblv;
}

double	timedialog::getSeconds()
{
	QString		s;
	float		f;

	s = secline->text();
	sscanf(s,"%f",&f);

	return (sec = f);
}

void	timedialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Seconds","1.0");
	sec = str.toDouble();

	str.sprintf("%f",sec);
	secline->setText(str);
}

void	timedialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = secline->text();
	sec = qstr.toDouble();
	qstr.sprintf("%f",sec);
	config->writeEntry("Seconds",qstr);

	addEntry(profilename);
}

void	timedialog::deleteProfile()
{
}

echodialog::echodialog(QWidget *parent=0,const char *name=0):
	kssdialog(parent,name,"Echo")
{
	volv = new QDoubleValidator(0.0,2.0,5,this);
	volv->setRange(0.0,2.0,5);

	delayv = new QDoubleValidator(0.001,10.0,5,this);
	delayv->setRange(0.001,10.0,5);

	releasev = new QDoubleValidator(0.0,10.0,5,this);
	releasev->setRange(0.0,10.0,5);

	delaylabel = new QLabel(this);
	delaylabel->setText(i18n("Delay (sec):"));

	delayline = new QLineEdit(this);
	delayline->setValidator(delayv);
	delayline->setText("0.3");

	vollabel = new QLabel(this);
	vollabel->setText(i18n("Volume (*):"));

	volline = new QLineEdit(this);
	volline->setValidator(volv);
	volline->setText("0.7");

	releaselabel = new QLabel(this);
	releaselabel->setText(i18n("Release (%):"));

	releaseline = new QLineEdit(this);
	releaseline->setValidator(releasev);
	releaseline->setText("1");

	resize(330,150);

	delaylabel->setGeometry(5,45,125,25);
	delayline->setGeometry(135,45,75,25);

	vollabel->setGeometry(5,75,125,25);
	volline->setGeometry(135,75,75,25);

	releaselabel->setGeometry(5,105,125,25);
	releaseline->setGeometry(135,105,75,25);

	delay = 0.5;
	vol = 0.5;
	release = 1;
}

echodialog::~echodialog()
{
	delete	delayline;
	delete	volline;
	delete	releaseline;
	delete	delaylabel;
	delete	vollabel;
	delete	releaselabel;
	delete	delayv;
	delete	volv;
	delete	releasev;
}

double	echodialog::getDelay()
{
	QString		s;
	float		f;

	s = delayline->text();
	sscanf(s,"%f",&f);

	return (delay = f);
}

double	echodialog::getVolume()
{
	QString		s;
	float		f;

	s = volline->text();
	sscanf(s,"%f",&f);

	return (vol = f);
}

double	echodialog::getRelease()
{
	QString		s;
	float		f;

	s = releaseline->text();
	sscanf(s,"%f",&f);

	return (release = f);
}

void	echodialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Volume","0.7");
	vol = str.toDouble();

	str = config->readEntry("Delay","0.5");
	delay = str.toDouble();

	str = config->readEntry("Release","1.0");
	release = str.toDouble();

	str.sprintf("%f",vol);
	volline->setText(str);

	str.sprintf("%f",delay);
	delayline->setText(str);

	str.sprintf("%f",release);
	releaseline->setText(str);
}

void	echodialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	qstr = delayline->text();
	delay = qstr.toDouble();
	qstr = volline->text();
	vol = qstr.toDouble();
	qstr = releaseline->text();
	release = qstr.toDouble();

	config->setGroup(group);

	qstr.sprintf("%f",delay);
	config->writeEntry("Delay",qstr);
	qstr.sprintf("%f",vol);
	config->writeEntry("Volume",qstr);
	qstr.sprintf("%f",release);
	config->writeEntry("Release",qstr);

	addEntry(profilename);
}

void	echodialog::deleteProfile()
{
}

fuzzdialog::fuzzdialog(QWidget *parent=0,const char *name=0) :
	kssdialog(parent,name,"Fuzz")
{
	volv = new QDoubleValidator(0.0,2.0,5,this);
	volv->setRange(0.0,2.0,5);

	cutv = new QDoubleValidator(1,100,5,this);
	cutv->setRange(1,100,5);

	cutlabel = new QLabel(this);
	cutlabel->setText(i18n("Cut (power):"));

	cutline = new QLineEdit(this);
	cutline->setValidator(cutv);
	cutline->setText("1");

	vollabel = new QLabel(this);
	vollabel->setText(i18n("Volume :"));

	volline = new QLineEdit(this);
	volline->setValidator(volv);
	volline->setText("0.7");

	resize(300,150);

	vollabel->setGeometry(5,45,95,25);
	volline->setGeometry(105,45,75,25);

	cutlabel->setGeometry(5,75,95,25);
	cutline->setGeometry(105,75,75,25);

	cut = 0.5;
	vol = 0.8;
	side = 1;
}

fuzzdialog::~fuzzdialog()
{
	delete	cutline;
	delete	volline;
	delete	cutlabel;
	delete	vollabel;
	delete	cutv;
	delete	volv;
}

double	fuzzdialog::getCut()
{
	QString		s;
	float		f;

	s = cutline->text();
	sscanf(s,"%f",&f);

	if(f <= 0) f = 0.0000001;

	return (cut = f);
}

double	fuzzdialog::getVolume()
{
	QString		s;
	float		f;

	s = volline->text();
	sscanf(s,"%f",&f);

	return (vol = f);
}

int	fuzzdialog::getSide()
{
	QString		s;
	int		f = 1;

/*
	s = sideline->text();
	sscanf(s,"%f",&f);
*/

	return (side = f);
}

void	fuzzdialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Volume","0.7");
	vol = str.toDouble();

	str = config->readEntry("Cut","2");
	cut = str.toDouble();

	side = config->readNumEntry("Side",1);

	str.sprintf("%f",vol);
	volline->setText(str);

	str.sprintf("%f",cut);
	cutline->setText(str);
}

void	fuzzdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = cutline->text();
	cut = qstr.toDouble();
	qstr = volline->text();
	vol = qstr.toDouble();
	qstr = sideline->text();
	side = qstr.toInt();

	qstr.sprintf("%f",vol);
	config->writeEntry("Volume",qstr);
	qstr.sprintf("%f",cut);
	config->writeEntry("Cut",qstr);
	config->writeEntry("Side",side);

	addEntry(profilename);
}

void	fuzzdialog::deleteProfile()
{
}


noisegatedialog::noisegatedialog(QWidget *parent=0,const char *name=0)
 :  	kssdialog(parent,name,"Volume")
{
	dblv = new QDoubleValidator(0.0,1.0,5,this);
	dblv->setRange(0.0,1.0,5);

	vollabel = new QLabel(this);
	vollabel->setText(i18n("Treshhold :"));

	volline = new QLineEdit(this);
	volline->setValidator(dblv);
	volline->setText("0.07");

	resize(300,150);

	vollabel->setGeometry(5,45,95,25);
	volline->setGeometry(105,45,75,25);

	vol = 0.07;
}

noisegatedialog::~noisegatedialog()
{
	delete	volline;
	delete	vollabel;
	delete	dblv;
}

double	noisegatedialog::getTreshhold()
{
	QString		s;
	float		f;

	s = volline->text();
	sscanf(s,"%f",&f);

	return (vol = f);
}

void	noisegatedialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Treshhold","0.07");
	vol = str.toDouble();

	str.sprintf("%f",vol);
	volline->setText(str);
}

void	noisegatedialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = volline->text();
	vol = qstr.toDouble();
	qstr.sprintf("%f",vol);
	config->writeEntry("Treshhold",qstr);

	addEntry(profilename);
}

void	noisegatedialog::deleteProfile()
{
}

compressdialog::compressdialog(QWidget *parent=0,const char *name=0)
 :  	kssdialog(parent,name,name)
{
	dblv = new QDoubleValidator(0.0,1.0,5,this);
	dblv->setRange(0.0,1.0,5);

	levellabel = new QLabel(this);
	levellabel->setText(i18n("Level :"));

	levelline = new QLineEdit(this);
	levelline->setValidator(dblv);
	levelline->setText("0.07");

	resize(300,150);

	levellabel->setGeometry(5,45,95,25);
	levelline->setGeometry(105,45,75,25);

	level = 0.07;
}

compressdialog::~compressdialog()
{
	delete	levelline;
	delete	levellabel;
	delete	dblv;
}

double	compressdialog::getLevel()
{
	QString		s;
	float		f;

	s = levelline->text();
	sscanf(s,"%f",&f);

	return (level = f);
}

void	compressdialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	str = config->readEntry("Level","0.07");
	level = str.toDouble();

	str.sprintf("%f",level);
	levelline->setText(str);
}

void	compressdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	qstr = levelline->text();
	level = qstr.toDouble();
	qstr.sprintf("%f",level);
	config->writeEntry("Level",qstr);

	addEntry(profilename);
}

void	compressdialog::deleteProfile()
{
}

/*
**
**
**	Formatdialog
**
**
*/
formatdialog::formatdialog(QWidget *parent=0,const char *name=0,int sr = 44100,int t = 0) :
	kssdialog(parent,name,"Format")
{
	char	str[20];

	sprintf(str,"%i",sr);

	samplerateval = new QDoubleValidator(0,100000,6,this);
	samplerateval->setRange(0,100000,6);

	sampleratelabel = new QLabel(this);
	sampleratelabel->setText(i18n("Samplerate:"));

	samplerateline = new QLineEdit(this);
	samplerateline->setValidator(samplerateval);
	samplerateline->setText(str);

	typeframe = new QFrame(this);
	typeframe->setFrameStyle(QFrame::Box | QFrame::Sunken);
	typeframe->setLineWidth(1);
	typeframe->setMidLineWidth(1);

	I8 = new QRadioButton("Integer 8 Bit",this);
	if(t == 0) I8->setChecked(1);
	connect(I8,SIGNAL(clicked()),this,SLOT(type8Clicked()));

	I16 = new QRadioButton("Integer 16 Bit",this);
	if(t == 1) I16->setChecked(1);
	connect(I16,SIGNAL(clicked()),this,SLOT(type16Clicked()));

	I32 = new QRadioButton("Integer 32 Bit",this);
	if(t == 2) I32->setChecked(1);
	connect(I32,SIGNAL(clicked()),this,SLOT(type32Clicked()));

	FL = new QRadioButton("Float",this);
	if(t == 3) FL->setChecked(1);
	connect(FL,SIGNAL(clicked()),this,SLOT(typeFLClicked()));

	DB = new QRadioButton("Double",this);
	if(t == 4) DB->setChecked(1);
	connect(DB,SIGNAL(clicked()),this,SLOT(typeDBClicked()));


	resize(300,225);

	sampleratelabel->setGeometry(5,45,95,25);
	samplerateline->setGeometry(105,45,75,25);

	typeframe->setGeometry(5,75,150,135);

	I8->setGeometry(10,80,140,25);
	I16->setGeometry(10,105,140,25);
	I32->setGeometry(10,130,140,25);
	FL->setGeometry(10,155,140,25);
	DB->setGeometry(10,180,140,25);
}

formatdialog::~formatdialog()
{
	delete	samplerateline;
	delete	sampleratelabel;
	delete	typeframe;
	delete	I8;
	delete	I16;
	delete	I32;
	delete	FL;
	delete	DB;
}

uint	formatdialog::getSampleRate()
{
	QString		s;
	int		i;

	s = samplerateline->text();
	sscanf(s,"%i",&i);

	return (samplerate = i);
}

uint	formatdialog::getType()
{
	if(I8->isChecked()) return 0;
	if(I16->isChecked()) return 1;
	if(I32->isChecked()) return 2;
	if(FL->isChecked()) return 3;
	if(DB->isChecked()) return 4;

	return 5;
}

void	formatdialog::type8Clicked()
{
	if(I8->isChecked())
	{
		I16->setChecked(0);
		I32->setChecked(0);
		FL->setChecked(0);
		DB->setChecked(0);
	}
}

void	formatdialog::type16Clicked()
{
	if(I16->isChecked())
	{
		I8->setChecked(0);
		I32->setChecked(0);
		FL->setChecked(0);
		DB->setChecked(0);
	}
}

void	formatdialog::type32Clicked()
{
	if(I32->isChecked())
	{
		I8->setChecked(0);
		I16->setChecked(0);
		FL->setChecked(0);
		DB->setChecked(0);
	}
}

void	formatdialog::typeFLClicked()
{
	if(FL->isChecked())
	{
		I8->setChecked(0);
		I16->setChecked(0);
		I32->setChecked(0);
		DB->setChecked(0);
	}
}

void	formatdialog::typeDBClicked()
{
	if(DB->isChecked())
	{
		I8->setChecked(0);
		I16->setChecked(0);
		I32->setChecked(0);
		FL->setChecked(0);
	}
}

void	formatdialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);
	samplerate = config->readNumEntry("Samplerate",44100);
	nchannel = config->readNumEntry("NChannel",2);
	type = config->readNumEntry("Type",4);

	str.sprintf("%i",samplerate);
	samplerateline->setText(str);

	str.sprintf("%i",nchannel);
	//nchannelline->setText(str);

	switch(type)
	{
		case 0: I8->setChecked(true); type8Clicked(); break;
		case 1: I16->setChecked(true); type16Clicked(); break;
		case 2: I32->setChecked(true); type32Clicked(); break;
		case 3: FL->setChecked(true); typeFLClicked(); break;
		case 4: DB->setChecked(true); typeDBClicked(); break;
	}
}

void	formatdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	samplerate = getSampleRate();
	nchannel = 2;//getNChannel();
	type = getType();

	qstr.sprintf("%i",samplerate);
	config->writeEntry("Samplerate",qstr);
	qstr.sprintf("%i",nchannel);
	config->writeEntry("NChannel",qstr);
	config->writeEntry("Type",type);

	addEntry(profilename);
}

void	formatdialog::deleteProfile()
{
}

/*
**
**
**	Newdialog
**
**
*/
newdialog::newdialog(QWidget *parent=0,const char *name=0,uint sr = 44100,uint t = 0,uint cn = 1) :
	kssdialog(parent,name,"New")
{
	char	str[20];

	sprintf(str,"%i",sr);

	samplerateval = new QDoubleValidator(0,100000,6,this);
	samplerateval->setRange(0,100000,6);

	nchannelval = new QDoubleValidator(0,10,1,this);
	nchannelval->setRange(0,10,1);

	sampleratelabel = new QLabel(this);
	sampleratelabel->setText(i18n("Samplerate:"));

	samplerateline = new QLineEdit(this);
	samplerateline->setValidator(samplerateval);
	samplerateline->setText(str);

	sprintf(str,"%i",cn);

	nchannellabel = new QLabel(this);
	nchannellabel->setText(i18n("Channels:"));

	nchannelline = new QLineEdit(this);
	nchannelline->setValidator(nchannelval);
	nchannelline->setText(str);

	typeframe = new QFrame(this);
	typeframe->setFrameStyle(QFrame::Box | QFrame::Sunken);
	typeframe->setLineWidth(1);
	typeframe->setMidLineWidth(1);

	I8 = new QRadioButton("Integer 8 Bit",this);
	if(t == 0) I8->setChecked(1);
	connect(I8,SIGNAL(clicked()),this,SLOT(type8Clicked()));

	I16 = new QRadioButton("Integer 16 Bit",this);
	if(t == 1) I16->setChecked(1);
	connect(I16,SIGNAL(clicked()),this,SLOT(type16Clicked()));

	I32 = new QRadioButton("Integer 32 Bit",this);
	if(t == 2) I32->setChecked(1);
	connect(I32,SIGNAL(clicked()),this,SLOT(type32Clicked()));

	FL = new QRadioButton("Float",this);
	if(t == 3) FL->setChecked(1);
	connect(FL,SIGNAL(clicked()),this,SLOT(typeFLClicked()));

	DB = new QRadioButton("Double",this);
	if(t == 4) DB->setChecked(1);
	connect(DB,SIGNAL(clicked()),this,SLOT(typeDBClicked()));


	resize(300,255);

	sampleratelabel->setGeometry(5,45,95,25);
	samplerateline->setGeometry(105,45,75,25);

	nchannellabel->setGeometry(5,75,95,25);
	nchannelline->setGeometry(105,75,75,25);

	typeframe->setGeometry(5,105,150,135);

	I8->setGeometry(10,110,140,25);
	I16->setGeometry(10,135,140,25);
	I32->setGeometry(10,160,140,25);
	FL->setGeometry(10,185,140,25);
	DB->setGeometry(10,210,140,25);
}

newdialog::~newdialog()
{
	delete	samplerateline;
	delete	sampleratelabel;
	delete	nchannelline;
	delete	nchannellabel;
	delete	typeframe;
	delete	I8;
	delete	I16;
	delete	I32;
	delete	FL;
	delete	DB;
}

uint	newdialog::getSampleRate()
{
	QString		s;
	int		i;

	s = samplerateline->text();
	sscanf(s,"%i",&i);

	return (samplerate = i);
}

uint	newdialog::getType()
{
	if(I8->isChecked()) return 0;
	if(I16->isChecked()) return 1;
	if(I32->isChecked()) return 2;
	if(FL->isChecked()) return 3;
	if(DB->isChecked()) return 4;

	return 5;
}

uint	newdialog::getNChannel()
{
	QString		s;
	int		i;

	s = nchannelline->text();
	sscanf(s,"%i",&i);

	return (nchannel = i);
}

void	newdialog::type8Clicked()
{
	if(I8->isChecked())
	{
		I16->setChecked(0);
		I32->setChecked(0);
		FL->setChecked(0);
		DB->setChecked(0);
	}
}

void	newdialog::type16Clicked()
{
	if(I16->isChecked())
	{
		I8->setChecked(0);
		I32->setChecked(0);
		FL->setChecked(0);
		DB->setChecked(0);
	}
}

void	newdialog::type32Clicked()
{
	if(I32->isChecked())
	{
		I8->setChecked(0);
		I16->setChecked(0);
		FL->setChecked(0);
		DB->setChecked(0);
	}
}

void	newdialog::typeFLClicked()
{
	if(FL->isChecked())
	{
		I8->setChecked(0);
		I16->setChecked(0);
		I32->setChecked(0);
		DB->setChecked(0);
	}
}

void	newdialog::typeDBClicked()
{
	if(DB->isChecked())
	{
		I8->setChecked(0);
		I16->setChecked(0);
		I32->setChecked(0);
		FL->setChecked(0);
	}
}

void	newdialog::loadProfile(const char* profilename)
{
	QString		group = "",str;
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);
	samplerate = config->readNumEntry("Samplerate",44100);
	nchannel = config->readNumEntry("NChannel",2);
	type = config->readNumEntry("Type",4);

	str.sprintf("%i",samplerate);
	samplerateline->setText(str);

	str.sprintf("%i",nchannel);
	nchannelline->setText(str);

	switch(type)
	{
		case 0: I8->setChecked(true); type8Clicked(); break;
		case 1: I16->setChecked(true); type16Clicked(); break;
		case 2: I32->setChecked(true); type32Clicked(); break;
		case 3: FL->setChecked(true); typeFLClicked(); break;
		case 4: DB->setChecked(true); typeDBClicked(); break;
	}
}

void	newdialog::saveProfile(const char *profilename)
{
	QString		group = "",qstr = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);

	samplerate = getSampleRate();
	nchannel = getNChannel();
	type = getType();

	qstr.sprintf("%i",samplerate);
	config->writeEntry("Samplerate",qstr);
	qstr.sprintf("%i",nchannel);
	config->writeEntry("NChannel",qstr);
	config->writeEntry("Type",type);

	addEntry(profilename);
}

void	newdialog::deleteProfile()
{
}

/*
**
**
**	Colordialog
**
**
*/
static	char	colorname[11][25] =
		{
			"Background",
			"Foreground",
			"NoSample",
			"Middleline",
			"Devidecolor",
			"Sel. Background",
			"Sel. Foreground",
			"Sel. Middleline",
			"Pointer",
			"Sel. Pointer",
			"Zoom"
		};

colordialog::colordialog(QWidget *parent,const char *name,QColor *c[11]) :
	kssdialog(parent,name,"Color")
{
	int		t,w;

	for(t = 0;t < 11;t++)
	{
		colorlabel[t] = new QLabel(this);
		colorlabel[t]->setText(i18n(colorname[t]));

		colorbt[t] = new KColorButton(*c[t],this);
		//colorbt[t]->setColor(c[t]);
	}

	w = 0;
	for(t = 0;t < 11;t++)
	{
		w = MAX(w,colorlabel[t]->sizeHint().width());
	}
	
	resize(165 + w,395);

	for(t = 0;t < 11;t++)
	{
		colorlabel[t]->setGeometry(5,45 + t * 30,w,25);
		colorbt[t]->setGeometry(10 + w,45 + t * 30,35,25);
	}
}

colordialog::~colordialog()
{
}

void	colordialog::getColors(QColor *c[11])
{
	int		t;

	for(t = 0;t < 11;t++)
	{
		*c[t] = colorbt[t]->color();
	}
}

void	colordialog::loadProfile(const char* profilename)
{
	QColor		c[11],*qc;
	int		t;
	QString		group = "";
	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	config->setGroup(group);
	qc = new QColor();
	qc->setRgb(255,255,255);
	c[0] = config->readColorEntry("Background",qc);
	qc->setRgb(0,0,0);
	c[1] = config->readColorEntry("Foreground",qc);
	qc->setRgb(100,100,150);
	c[2] = config->readColorEntry("NoColor",qc);
	qc->setRgb(0,200,0);
	c[3] = config->readColorEntry("Middleline",qc);
	qc->setRgb(50,50,50);
	c[4] = config->readColorEntry("Devideline",qc);
	qc->setRgb(0,0,0);
	c[5] = config->readColorEntry("SelectedBackground",qc);
	qc->setRgb(255,255,255);
	c[6] = config->readColorEntry("SelectedForeground",qc);
	qc->setRgb(200,0,0);
	c[7] = config->readColorEntry("SelectedMiddleline",qc);
	qc->setRgb(0,0,200);
	c[8] = config->readColorEntry("Pointer",qc);
	qc->setRgb(0,0,200);
	c[9] = config->readColorEntry("SelectedPointer",qc);
	qc->setRgb(0,0,150);
	c[10] = config->readColorEntry("Zoom",qc);

	delete qc;
	config->sync();

	for(t = 0;t < 11;t++)
	{
		colorbt[t]->setColor(c[t]);
	}
}

void	colordialog::saveProfile(const char* profilename)
{
	QColor		*c[11];
	int		t;
	QString		group = "",qstr = "";
 	KConfig	*config = KApplication::getKApplication()->getConfig();

	group = profile + "/" + profilename;

	for(t = 0;t < 11;t++) c[t] = new QColor();

	getColors(c);

	config->setGroup(group);
	config->writeEntry("Background",*c[0]);
	config->writeEntry("Foreground",*c[1]);
	config->writeEntry("NoColor",*c[2]);
	config->writeEntry("Middleline",*c[3]);
	config->writeEntry("Devideline",*c[4]);
	config->writeEntry("SelectedBackground",*c[5]);
	config->writeEntry("SelectedForeground",*c[6]);
	config->writeEntry("SelectedMiddleline",*c[7]);
	config->writeEntry("Pointer",*c[8]);
	config->writeEntry("SelectedPointer",*c[9]);
	config->writeEntry("Zoom",*c[10]);

	for(t = 0;t < 11;t++) delete c[t];

	addEntry(profilename);
}

void	colordialog::deleteProfile()
{
}

/*
**
**
**	Progessdialog
**
**
*/
progressdialog::progressdialog(QApplication *a,QWidget *parent=0,const char *name=0) :
	QDialog(parent,name,true)
{
	app = a;

	label = new QLabel(this);
	progress = new KProgress(0,1000,0,KProgress::Horizontal,this);
	
	setMaximumSize(150,65);
	QDialog::resize(150,65);
	setMinimumSize(150,65);

	label->setGeometry(5,5,140,25);
	progress->setGeometry(5,35,140,25);	
	//cancel->setGeometry(40,35,80,25);
}

progressdialog::~progressdialog()
{
	delete	label;
	delete	progress;
	//delete	cancel;
}

void	progressdialog::setText(QString str)
{
	label->setText(str.data());
}

void	progressdialog::setProgress(double p)
{
	progress->setValue((int)(1000.0 * p));
}

void	progressdialog::sync()
{
	app->processEvents(1);
	app->flushX();
}


/*
**
**
**	Optionsdialog
**
**
*/
optiondialog::optiondialog(QWidget *parent,const char *name) :
	QDialog(parent,name,true)
{
	QString		group = "",str;

	ok = new QPushButton(this);
	ok->setText("OK");
	cancel = new QPushButton(this);
	cancel->setText("Cancle");
	
	dsplabel[0] = new QLabel(this);
	dsplabel[0]->setText(i18n("DSP-device 0:"));
	dspline[0] = new QLineEdit(this);
	dspline[0]->setText("/dev/dsp");
	
	dsplabel[1] = new QLabel(this);
	dsplabel[1]->setText(i18n("DSP-device 1:"));
	dspline[1] = new QLineEdit(this);
	dspline[1]->setText("/dev/dsp1");
	
	setMaximumSize(225,105);
	QDialog::resize(225,105);
	setMinimumSize(225,105);

	dsplabel[0]->setGeometry(5,5,100,25);
	dspline[0]->setGeometry(110,5,100,25);	
	dsplabel[1]->setGeometry(5,35,100,25);
	dspline[1]->setGeometry(110,35,100,25);	


	cancel->setGeometry(25,75,80,25);
	ok->setGeometry(110,75,80,25);

	group = "Option";

/*
	config->setGroup(group);

	str = config->readEntry("DSP0","/dev/dsp");
	dspline[0]->setText(str);
		
	str = config->readEntry("DSP1","/dev/dsp1");
 	dspline[1]->setText(str);
*/
	
	connect(ok,SIGNAL(clicked()),this,SLOT(okPressed()));
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

optiondialog::~optiondialog()
{
}

void	optiondialog::setDSP(QString str,int n)
{
	dspline[n]->setText(str.data());
}

QString	optiondialog::getDSP(int n)
{
	return dspline[n]->text();
}

void	optiondialog::okPressed()
{
	QString		group = "",qstr = "";

	group = "Option";

/*
	config->setGroup(group);

	qstr = dspline[0]->text();
	config->writeEntry("DSP0",qstr);
	qstr = dspline[1]->text();
	config->writeEntry("DSP1",qstr);
	config->sync();
*/
	
	accept();
}





