/***************************************************************************
                          timebar.h  -  description                              
                             -------------------                                         
    begin                : Fri Dec 17 1999                                           
    copyright            : (C) 1999 by Tobias Wollgam                         
    email                : Tobias.Wollgam@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef TIMEBAR_H
#define TIMEBAR_H

#include <qwidget.h>
#include <qframe.h>

/**
  * A widgetclass for displaying a timeline. It searches automatically a resolution
  * for tickmark distance and labeling of every tenth tickmark. To provide accuracy even for
  * applications displaying in millisecond range, Timebar uses microseconds for calculation.
  * This brings the need for 64bit integer calculation, witch is provided by long long int
  * on x86 machines.
	* @see QFrame
	*
  * @author Tobias Wollgam
	* @version KDevelop version 0.4 code generation
  */

#define TIME(h,m,s,ms)	(long long)(1000 * ((long long)ms + 1000 * ((long long)s + 60 * ((long long)m + 60 * (long long)h))))
#define UTIME(h,m,s,ms)	(int)(((int)ms + 1000 * ((int)s + 60 * ((int)m + 60 * (int)h))))

class Timebar : public QFrame
{
   Q_OBJECT
public: 
  /** Constructor for the Timebar. */
	Timebar(QWidget *parent=0, const char *name=0);
  /** Destructor for the Timebar. */
	~Timebar();
	
  /** Scale/fix modes for the Timebar. */
	enum Mode	{Scale = 0,FixLeft,FixRight,	FixCenter};
	
  /** Returns the start second of Timebar. */
  int				startSecond();
  /** Returns the end second of Timebar. */
  int				endSecond();
  /** Returns the actual microseconds per pixel of Timebar. */
  long long	microSecondsPerPixel();
  /** Returns the stop mark in microseconds of Timebar.
  	* @see setStopMarkMicroSeconds */
  long long	stopMarkMicroSeconds();
  /** Returns the scale/fix mode.
  	* @see setMode()
  	* @see Mode{} */
  Mode			mode();

public slots: // Public slots
  /** Sets the visible time range in mircoseconds.
  	* The value starttime is the time very left,
  	* the value endtime is the time very right on the Timebar.
  	* The starttime has to be smaller than endtime, else
  	* the values will not be set.
  	*/
  void			setRangeMicroSeconds(long long starttime,long long endtime);
  /** Sets the visible time range in milliseconds.
  	* @see  setRangeMicroSeconds()
  	*/
  void			setRangeMilliSeconds(long long starttime,long long endtime);
  /** Sets the visible time range in seconds.
  	* @see  setRangeMicroSeconds()
  	*/
  void			setRangeSeconds(int starttime,int endtime);
  /** Sets the visible start time in microseconds.
  	* The endtime is changed in the same way.
  	* If you want the endtime fix use setRangeMicroSeconds().
  	* @see  setRangeMicroSeconds()
  	*/
  void			setStartMicroSecond(long long starttime);
  /** Sets the visible start time in milliseconds.
  	* @see  setStartMicroSecond()
  	*/
  void			setStartMilliSecond(long long starttime);
  /** Sets the visible start time in milliseconds.
  	* @see  setStartMicroSecond()
  	*/
  void			setStartMilliSecond(int starttime);
  /** Sets the visible start time in seconds.
  	* @see  setStartMicroSecond()
  	*/
  void			setStartSecond(int starttime);
  /** Sets the stop mark in microseconds.
  	* The stop mark is the last tickmark which will be displayed.
  	* It will be disabled if stop mark lies before the start time.
  	*/
  void			setStopMarkMicroSeconds(long long stopmark);
  /** Sets the stop mark in milliseconds.
  	* @see setStopMarkMicroSeconds()
  	*/
  void			setStopMarkMilliSeconds(long long stopmark);
  /** Sets the stop mark in milliseconds.
  	* @see setStopMarkMicroSeconds()
  	*/
  void			setStopMarkMilliSeconds(int stopmark);
  /** Sets the stop mark in seconds.
  	* @see setStopMarkMicroSeconds()
  	*/
  void			setStopMarkSeconds(int stopmark);
  /** Sets the amount of microseconds per pixel.
  	* The starttime and endtime changes in dependence of the given fixmode.
  	* Is the fixmode Scale the set fixmode (setMode()) is taken.
  	* Only if the set mode is itself Scale, Timebar will use FixLeft.
  	* For mode FixLeft starttime isn't touched.  	
  	* For mode FixRight endtime isn't touched.
  	* For mode FixCenter both starttime and endtime are changed in a way, so
  	* that the center of the Timebar is fix.
  	* @see setMode()
  	*/
  void			setMicroSecondsPerPixel(long long microssecondsperpixel,Mode fixmode = FixLeft);
  /** Sets the scale/fix mode.
  	* @see mode()
  	* @see Mode{}
  	*/
  void			setMode(Mode fixmode);
	
protected:
	void			sprinttf(QString &d,QString f,long long v);
 	void			paintEvent(QPaintEvent *pe);
	void			resizeEvent(QResizeEvent *re);
 	void			draw();
  long long	roundup(long long);


protected: // Protected attributes
  /**  */
  long long m_starttime;
  long long m_endtime;
  long long m_stopmark;
  long long m_startselect;
  long long m_endselect;
  Mode			m_mode;
	QString		m_format;
	QPainter	*m_qp;
};

#endif



















