/* $Id: korranzeige.cc,v 1.4 1999/04/24 14:28:47 philipp Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>
#include <qpainter.h>

#include "korranzeige.moc"

KorrAnzeige::KorrAnzeige(QWidget* parent, const char* name)
  : QFrame(parent, name) {
  setBackgroundColor(QColor(0, 0, 0));
  setFrameStyle(WinPanel | Sunken);
  setLineWidth(2);
  korrelation = 0.0;
}

void KorrAnzeige::neueDaten(const unsigned char* buffer, unsigned int
			    bufsize) {
  unsigned int punkte = bufsize / 2;
  double ksumme = 0.0;
  double rqsumme = 0.0;
  double lqsumme = 0.0;
  for (unsigned int i = 0; i < punkte; i++) {
    int r = (int) buffer[i * 2] - 128;
    int l = (int) buffer[i * 2 + 1] - 128;
    ksumme += r * l;
    rqsumme += r * r;
    lqsumme += l * l;
  }
  double neue_korrelation = ksumme / sqrt(lqsumme * rqsumme);

  QPainter qp;
  if (qp.begin(this)) {
    qp.setPen(QPen(QColor(0, 0, 0), 3));
    int x = (korrelation + 1.0) * (width() - 6) / 2 + 3;
    qp.moveTo(x, 3);
    qp.lineTo(x, height() - 3);

    for (int y = 2; y <= width() - 3; y += (width() - 6) / 8) {
      if (x >= y - 1 && x <= y + 1) {
	qp.setPen(QPen(QColor(128, 128, 128), 1));
	qp.moveTo(y, 3);
	qp.lineTo(y, height() - 3);
      }
    }

    qp.setPen(QPen(QColor(255, 0, 0), 3));
    x = (neue_korrelation + 1.0) * (width() - 6) / 2 + 3;
    qp.moveTo(x, 3);
    qp.lineTo(x, height() - 3);

    qp.end();
    
    korrelation = neue_korrelation;
  }
}

void KorrAnzeige::paintEvent(QPaintEvent* qpevt) {
  QPainter qp;
  if (qp.begin(this)) {
    drawFrame(&qp);

    qp.setPen(QPen(QColor(128, 128, 128), 1));
    for (int x = 2; x <= width() - 3; x += (width() - 6) / 8) {
      qp.moveTo(x, 3);
      qp.lineTo(x, height() - 3);
    }

    qp.setPen(QPen(QColor(255, 0, 0), 3));
    int x = (korrelation + 1.0) * (width() - 6) / 2 + 3;
    qp.moveTo(x, 3);
    qp.lineTo(x, height() - 3);

    qp.end();
  }
}
