/* $Id: kstereo.cc,v 1.5 1999/04/24 14:36:28 philipp Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmenubar.h>
#include <qdialog.h>
#include <qstring.h>
#include <qkeycode.h>

#include "kstereoOptionen.h"
#include "kstereo.moc"

KStereoFenster::KStereoFenster() : KTMainWindow() {
  KMenuBar* mb = menuBar();

  QPopupMenu* fileMenu = new QPopupMenu;
  fileMenu->insertItem(i18n("&Options"), this,
		       SLOT(oeffneKonfigDialog()));
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("&Quit"), kapp, SLOT(quit()), CTRL+Key_Q);
  mb->insertItem(i18n("&File"), fileMenu);
  mb->insertSeparator();
  QString AboutText(1024);
  AboutText.sprintf(i18n("KStereo\nCopyright  1999 Philipp Hullmann"),
		    VERSION);
  QPopupMenu* helpMenu = kapp->getHelpMenu(false, AboutText);
  mb->insertItem(i18n("&Help"), helpMenu);

  KConfig* conf = kapp->getConfig();
  conf->setGroup("KStereo");
  QString device = conf->readEntry("DSP_Device");
  if (device.isEmpty()) {
    device = "/dev/dsp";
    conf->writeEntry("DSP_Device", device);
  }
  unsigned int rate = conf->readUnsignedNumEntry("SamplingRate");
  if (rate == 0) {
    rate = 44100;
    conf->writeEntry("SamplingRate", rate);
  }
  unsigned int intervall = conf->readUnsignedNumEntry("Interval");
  if (intervall == 0) {
    intervall = 10;
    conf->writeEntry("Interval", intervall);
  }
  unsigned int log = conf->readUnsignedNumEntry("LogPoints");
  if (log == 0) {
    log = 5000;
    conf->writeEntry("LogPoints", log);
  }

  conf->sync();

  sview = new StereoView(this, "stereoview", device, rate, intervall, log);
  setView(sview);
  updateRects();
}

KStereoFenster::~KStereoFenster() {
  delete sview;
}

void KStereoFenster::oeffneKonfigDialog() {
  kstereoOptionen ko(this, sview);
  ko.exec();
}

int main(int argc, char* argv[]) {
  KApplication* a = new KApplication(argc, argv, "kstereo");
  a->enableSessionManagement();
  KStereoFenster* f = new KStereoFenster();
  a->setTopWidget(f);
  f->show();
  return a->exec();
}
