	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __AUTOROUTER_H_
#define __AUTOROUTER_H_

#include <qstring.h>

#ifdef HAVE_MINI_STL
#include <ministl/list>
#else
#include <list>
#endif

class tryinfo
{
public:
	int x1,x2,y1,y2,score,depth;
	QString history;
};

class AutoRouter
{
public:
	enum {none=0,up=1,down=2,left=4,right=8,head=16,tail=32,solid=64};

protected:
	const int OWNER_UD=0;
	const int OWNER_LR=1;

	struct Field
	{
		long data;
		long minscore;
		long penalty;
		long owner[2];
	} **field;

	long directionmask[256];
	int ownerindex[256];

	long newowner;
	long currentowner;

	QString minhistory;
	list<tryinfo> trylist;

	int width,height;
	long *prp, *prstart;

	void try_connect(int x1, int y1, int x2, int y2, int score, int depth, QString history);
	void q_try_connect(int x1, int y1, int x2, int y2, int score, int depth, QString history);

public:
	long get(int x,int y);
	void getowners(int x,int y, long& ud_owner, long& lr_owner);
	void set(int x,int y, long lt);
	long connect(int x1, int y1, int x2, int y2, long owner);
	void clear();

	AutoRouter(int width, int height);
};

#endif
