	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __MODULE_H_
#define __MODULE_H_

#include "synth.h"

#ifdef HAVE_MINI_STL
#include <ministl/list>
#else
#include <list>
#endif

#include <qpixmap.h>
#include <qstring.h>
#include <qrect.h>
#include <ksimpleconfig.h>

class Module;

class ModulePort
{
public:
	enum ConnType {none,source,dest,value};
	enum Direction {in,out};

	bool 		selected;
	Module	   *owner;

	QString		description;
	QRect		clickrect;
	ModulePort *connection;
	ConnType	conntype;
	Direction	direction;
	int			portnr;
	bool		isinitarg;

	long		route_owner;

	QString		strvalue;
	float		connvalue;

	ModulePort(Module *owner, char *description, int portnr, Direction direction);
	void save(KSimpleConfig &out);
	void load(KSimpleConfig &in, list<Module *> ModuleList);

	QString	getID();
	QString portVal();
};

class Module
{
public:
	Module(ModuleInfo *minfo);
	void save(KSimpleConfig &out);
	void load(KSimpleConfig &in);
	void loadPorts(KSimpleConfig &in, list<Module *> ModuleList);
	QString execute();

	ModulePort *findPort(QString id);
	QString	getID();

	QPixmap *pixmap;
	QString type;
	bool selected;
	int modnr;

	int x,y,width,height;
	list<ModulePort *> inports,outports;
};

#endif
