	/*

	The sound support for the synthesizer is based on routines of
	mpeg3play version 0.9.6. That software is based on a mpeg
	decoder source from Frauenhofer - IIS.

	Read README.sound for details about copyright and disclaimers.

    */

#if defined(__FreeBSD__)
# include <machine/soundcard.h>
#else
# include <sys/soundcard.h>
#endif
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
/* not required, for debugging only */

/*
 * Sound-specific stuff for VOXware compatible audio devices.
 */

int sound_init(int audiofd, int samplefrq, int stereo)
{
    int		tmp;

    /* Sample size/precision? */
    tmp = AFMT_S16_LE;
    if (ioctl(audiofd, SNDCTL_DSP_SETFMT, &tmp) == -1) {
		perror("SNDCTL_DSP_SETFMT");
		return(1);
    }
    if (tmp != AFMT_S16_LE) {
		perror("Soundcard doesn't support 16 bit sound!");
		return(1);
    }

    /* Mono/stereo */
    tmp = stereo;
#if defined(__FreeBSD__)
#define SNDCTL_DSP_CHANNELS SOUND_PCM_WRITE_CHANNELS
#endif
    if (ioctl(audiofd, SNDCTL_DSP_CHANNELS, &tmp) == -1) {
		perror("SNDCTL_DSP_CHANNELS");
		return(1);
    }

	fprintf(stderr,"channels set to %d (tried %d)\n",tmp, stereo);

    /*
     * Frequency, this has to be set after the number of channels
     * is selected otherwise SBPros fuck up
     */
    if (ioctl(audiofd, SNDCTL_DSP_SPEED, &samplefrq) == -1) {
		perror("SNDCTL_DSP_SPEED");
		return(1);
    }

    /*
     * Improves transport of sample data to audio device
     */
    tmp=12;
    ioctl(audiofd, SNDCTL_DSP_SETFRAGMENT, &tmp);
     /*
      * Raise the priority of audio device operations. This
      * only works if mpeg3play runs as root.
      */
    nice(-11);

    return(0);
}

int sound_open() {
    return(open("/dev/dsp", O_WRONLY));
}

int sound_close(int audiofd) {
    return(close(audiofd));
}

int sound_write(int audiofd, const void *buffer, size_t count) {
    return(write(audiofd, buffer, count));
}

int sound_realtime(int audio_fd, int pbsize)
{
    int arg =  0x70008;  // (pbsize-1)+0x40000;

    if (ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &arg))
    {
        fprintf(stderr,"unable to make things go in realtime\n");
        exit(0);
    }
}
